/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.throttle;

import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.ThreadPoolExecutor;

final class ActuateThrottleMetrics {
    final MeterRegistry registryInstance;

    ActuateThrottleMetrics(MeterRegistry registryInstance) {
        this.registryInstance = registryInstance;
    }

    void bind(ThreadPoolExecutor pool) {
        Gauge.builder((String)"zipkin_storage.throttle.concurrency", pool::getCorePoolSize).description("number of threads running storage requests").register(this.registryInstance);
        Gauge.builder((String)"zipkin_storage.throttle.queue_size", pool.getQueue()::size).description("number of items queued waiting for access to storage").register(this.registryInstance);
    }

    void bind(AbstractLimiter limiter) {
        Gauge.builder((String)"zipkin_storage.throttle.in_flight_requests", () -> ((AbstractLimiter)limiter).getInflight()).description("number of requests the limiter thinks are active").register(this.registryInstance);
    }
}

