/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zipkin2.Span;
import zipkin2.codec.BytesDecoder;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.server.internal.ZipkinHttpCollector;

final class BodyIsExceptionMessage
implements ExceptionHandlerFunction {
    static final Logger LOGGER = LogManager.getLogger();
    static final byte[] BINARY_ANNOTATION_FIELD_SUFFIX = new byte[]{121, 65, 110, 110, 111, 116, 97, 116, 105, 111, 110, 115, 34};
    static final byte[] ENDPOINT_FIELD_SUFFIX = new byte[]{69, 110, 100, 112, 111, 105, 110, 116, 34};
    static final byte[] TAGS_FIELD = new byte[]{34, 116, 97, 103, 115, 34};

    BodyIsExceptionMessage() {
    }

    public HttpResponse handleException(RequestContext ctx, HttpRequest req, Throwable cause) {
        ZipkinHttpCollector.metrics.incrementMessagesDropped();
        String message = cause.getMessage();
        if (message == null) {
            message = cause.getClass().getSimpleName();
        }
        if (cause instanceof IllegalArgumentException) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TEXT_TYPE, (String)message);
        }
        LOGGER.warn("Unexpected error handling request.", cause);
        return HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (MediaType)MediaType.ANY_TEXT_TYPE, (String)message);
    }

    static SpanBytesDecoder testForUnexpectedFormat(BytesDecoder<Span> decoder, ByteBuffer body) {
        if (decoder == SpanBytesDecoder.JSON_V2) {
            if (BodyIsExceptionMessage.contains(body, BINARY_ANNOTATION_FIELD_SUFFIX)) {
                return SpanBytesDecoder.JSON_V1;
            }
        } else if (decoder == SpanBytesDecoder.JSON_V1 && (BodyIsExceptionMessage.contains(body, ENDPOINT_FIELD_SUFFIX) || BodyIsExceptionMessage.contains(body, TAGS_FIELD))) {
            return SpanBytesDecoder.JSON_V2;
        }
        return null;
    }

    static boolean contains(ByteBuffer bytes, byte[] subsequence) {
        block0: for (int i = 0; i < bytes.remaining() - subsequence.length + 1; ++i) {
            for (int j = 0; j < subsequence.length; ++j) {
                if (bytes.get(bytes.position() + i + j) != subsequence[j]) continue block0;
            }
            return true;
        }
        return false;
    }
}

