/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import brave.ScopedSpan;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpTracing;
import brave.okhttp3.TracingInterceptor;
import brave.propagation.CurrentTraceContext;
import com.linecorp.armeria.common.RequestContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.server.internal.ConditionalOnSelfTracing;
import zipkin2.server.internal.WrappingExecutorService;
import zipkin2.server.internal.elasticsearch.BasicAuthInterceptor;
import zipkin2.server.internal.elasticsearch.ZipkinElasticsearchStorageProperties;
import zipkin2.storage.StorageComponent;

@Configuration
@EnableConfigurationProperties(value={ZipkinElasticsearchStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="elasticsearch")
@ConditionalOnMissingBean(value={StorageComponent.class})
public class ZipkinElasticsearchStorageAutoConfiguration {
    static final String QUALIFIER = "zipkinElasticsearchHttp";
    @Autowired(required=false)
    @Qualifier(value="zipkinElasticsearchHttp")
    List<Interceptor> zipkinElasticsearchHttpNetworkInterceptors = Collections.emptyList();
    @Autowired(required=false)
    ElasticsearchStorage.HostsSupplier hostsSupplier;

    @Bean
    @Qualifier(value="zipkinElasticsearchHttp")
    OkHttpClient.Builder zipkinElasticsearchHttpBuilder() {
        return new OkHttpClient.Builder();
    }

    @Bean
    @Qualifier(value="zipkinElasticsearchHttp")
    OkHttpClient zipkinElasticsearchHttp(OkHttpClient.Builder zipkinElasticsearchHttpBuilder, @Value(value="${zipkin.storage.elasticsearch.timeout:10000}") int timeout) {
        for (Interceptor interceptor : this.zipkinElasticsearchHttpNetworkInterceptors) {
            zipkinElasticsearchHttpBuilder.addNetworkInterceptor(interceptor);
        }
        return zipkinElasticsearchHttpBuilder.connectTimeout((long)timeout, TimeUnit.MILLISECONDS).readTimeout((long)timeout, TimeUnit.MILLISECONDS).writeTimeout((long)timeout, TimeUnit.MILLISECONDS).build();
    }

    @Bean
    @Qualifier(value="zipkinElasticsearchHttp")
    @Conditional(value={HttpLoggingSet.class})
    Interceptor zipkinElasticsearchHttpLoggingInterceptor(ZipkinElasticsearchStorageProperties es) {
        Logger logger = Logger.getLogger(ElasticsearchStorage.class.getName());
        return new HttpLoggingInterceptor(logger::info).setLevel(es.getHttpLogging());
    }

    @Bean
    @Qualifier(value="zipkinElasticsearchHttp")
    @Conditional(value={BasicAuthRequired.class})
    Interceptor zipkinElasticsearchHttpBasicAuthInterceptor(ZipkinElasticsearchStorageProperties es) {
        return new BasicAuthInterceptor(es);
    }

    @Bean
    @ConditionalOnMissingBean
    StorageComponent storage(ZipkinElasticsearchStorageProperties elasticsearch, @Qualifier(value="zipkinElasticsearchHttp") OkHttpClient zipkinElasticsearchHttp, @Value(value="${zipkin.query.lookback:86400000}") int namesLookback, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys, @Value(value="${zipkin.storage.autocomplete-ttl:3600000}") int autocompleteTtl, @Value(value="${zipkin.storage.autocomplete-cardinality:20000}") int autocompleteCardinality) {
        ElasticsearchStorage.Builder result = elasticsearch.toBuilder(zipkinElasticsearchHttp).namesLookback(namesLookback).strictTraceId(strictTraceId).searchEnabled(searchEnabled).autocompleteKeys(autocompleteKeys).autocompleteTtl(autocompleteTtl).autocompleteCardinality(autocompleteCardinality);
        if (this.hostsSupplier != null) {
            result.hostsSupplier(this.hostsSupplier);
        }
        return result.build();
    }

    static ExecutorService makeContextAware(final ExecutorService delegate, final CurrentTraceContext traceCtx) {
        class TracingCurrentRequestContextExecutorService
        extends WrappingExecutorService {
            TracingCurrentRequestContextExecutorService() {
            }

            @Override
            protected ExecutorService delegate() {
                return delegate;
            }

            @Override
            protected <C> Callable<C> wrap(Callable<C> task) {
                return RequestContext.current().makeContextAware(traceCtx.wrap(task));
            }

            @Override
            protected Runnable wrap(Runnable task) {
                return RequestContext.current().makeContextAware(traceCtx.wrap(task));
            }
        }
        return new TracingCurrentRequestContextExecutorService();
    }

    private static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    static final class BasicAuthRequired
    implements Condition {
        BasicAuthRequired() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata ignored) {
            String userName = condition.getEnvironment().getProperty("zipkin.storage.elasticsearch.username");
            String password = condition.getEnvironment().getProperty("zipkin.storage.elasticsearch.password");
            return !ZipkinElasticsearchStorageAutoConfiguration.isEmpty(userName) && !ZipkinElasticsearchStorageAutoConfiguration.isEmpty(password);
        }
    }

    static final class HttpLoggingSet
    implements Condition {
        HttpLoggingSet() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata ignored) {
            return !ZipkinElasticsearchStorageAutoConfiguration.isEmpty(condition.getEnvironment().getProperty("zipkin.storage.elasticsearch.http-logging"));
        }
    }

    @Configuration
    @ConditionalOnSelfTracing
    static class TracingOkHttpClientBuilderEnhancer
    implements BeanPostProcessor {
        @Autowired(required=false)
        HttpTracing httpTracing;
        @Autowired(required=false)
        Tracing tracing;

        TracingOkHttpClientBuilderEnhancer() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (this.httpTracing == null || !"zipkinElasticsearchHttpBuilder".equals(beanName)) {
                return bean;
            }
            final Tracer tracer = this.tracing.tracer();
            OkHttpClient.Builder builder = (OkHttpClient.Builder)bean;
            builder.addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    if (tracer.currentSpan() == null) {
                        return chain.proceed(chain.request());
                    }
                    Request request = chain.request();
                    ScopedSpan span = tracer.startScopedSpan(request.tag().toString());
                    try {
                        Response response = chain.proceed(request);
                        return response;
                    }
                    catch (IOException | Error | RuntimeException e) {
                        span.error(e);
                        throw e;
                    }
                    finally {
                        span.finish();
                    }
                }
            });
            builder.addNetworkInterceptor(TracingInterceptor.create((HttpTracing)this.httpTracing.clientOf("elasticsearch")));
            ExecutorService delegate = new Dispatcher().executorService();
            builder.dispatcher(new Dispatcher(ZipkinElasticsearchStorageAutoConfiguration.makeContextAware(delegate, this.tracing.currentTraceContext())));
            return builder;
        }
    }
}

