/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Post;
import io.netty.buffer.ByteBufHolder;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.CompletionStage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import zipkin2.Callback;
import zipkin2.Span;
import zipkin2.SpanBytesDecoderDetector;
import zipkin2.codec.BytesDecoder;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.server.internal.BodyIsExceptionMessage;
import zipkin2.server.internal.CompletableCallback;
import zipkin2.server.internal.ConsumesProtobuf;
import zipkin2.server.internal.ConsumesThrift;
import zipkin2.server.internal.UnzippingBytesRequestConverter;
import zipkin2.storage.StorageComponent;

@ConditionalOnProperty(name={"zipkin.collector.http.enabled"}, matchIfMissing=true)
@ExceptionHandler(value=BodyIsExceptionMessage.class)
public class ZipkinHttpCollector {
    static final Logger LOGGER = LogManager.getLogger();
    static volatile CollectorMetrics metrics;
    final Collector collector;

    ZipkinHttpCollector(StorageComponent storage, CollectorSampler sampler, CollectorMetrics metrics) {
        metrics = metrics.forTransport("http");
        this.collector = Collector.newBuilder(this.getClass()).storage(storage).sampler(sampler).metrics(metrics).build();
        ZipkinHttpCollector.metrics = metrics;
    }

    @Post(value="/api/v2/spans")
    public HttpResponse uploadSpans(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V2, ctx, req);
    }

    @Post(value="/api/v2/spans")
    @ConsumesJson
    public HttpResponse uploadSpansJson(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V2, ctx, req);
    }

    @Post(value="/api/v2/spans")
    @ConsumesProtobuf
    public HttpResponse uploadSpansProtobuf(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.PROTO3, ctx, req);
    }

    @Post(value="/api/v1/spans")
    public HttpResponse uploadSpansV1(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V1, ctx, req);
    }

    @Post(value="/api/v1/spans")
    @ConsumesJson
    public HttpResponse uploadSpansV1Json(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V1, ctx, req);
    }

    @Post(value="/api/v1/spans")
    @ConsumesThrift
    public HttpResponse uploadSpansV1Thrift(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.THRIFT, ctx, req);
    }

    HttpResponse validateAndStoreSpans(SpanBytesDecoder decoder, ServiceRequestContext ctx, HttpRequest req) {
        CompletableCallback result = new CompletableCallback();
        req.aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc()).handle((msg, t) -> {
            if (t != null) {
                result.onError((Throwable)t);
                return null;
            }
            try {
                HttpData content;
                try {
                    content = UnzippingBytesRequestConverter.convertRequest(ctx, msg);
                }
                catch (IllegalArgumentException e) {
                    result.onError(e);
                    Object var8_10 = null;
                    ReferenceCountUtil.release((Object)msg.content());
                    return var8_10;
                }
                if (content.isEmpty()) {
                    result.onSuccess(null);
                    Object e = null;
                    return e;
                }
                ByteBuffer nioBuffer = content instanceof ByteBufHolder ? ((ByteBufHolder)content).content().nioBuffer() : ByteBuffer.wrap(content.array(), content.offset(), content.length());
                try {
                    SpanBytesDecoderDetector.decoderForListMessage((ByteBuffer)nioBuffer);
                }
                catch (IllegalArgumentException e) {
                    result.onError(new IllegalArgumentException("Expected a " + decoder + " encoded list\n"));
                    Object var9_13 = null;
                    ReferenceCountUtil.release((Object)msg.content());
                    return var9_13;
                }
                SpanBytesDecoder unexpectedDecoder = BodyIsExceptionMessage.testForUnexpectedFormat((BytesDecoder<Span>)decoder, nioBuffer);
                if (unexpectedDecoder != null) {
                    result.onError(new IllegalArgumentException("Expected a " + decoder + " encoded list, but received: " + unexpectedDecoder + "\n"));
                    Object var9_14 = null;
                    return var9_14;
                }
                ArrayList spans = new ArrayList();
                if (!decoder.decodeList(nioBuffer, spans)) {
                    result.onError(new IllegalArgumentException("Empty " + decoder.name() + " message"));
                    Object var10_16 = null;
                    return var10_16;
                }
                this.collector.accept(spans, (Callback)result);
            }
            finally {
                ReferenceCountUtil.release((Object)msg.content());
            }
            return null;
        });
        return HttpResponse.from((CompletionStage)result);
    }

    static void maybeLog(String prefix, ServiceRequestContext ctx, AggregatedHttpMessage request) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        LOGGER.debug("{} sent by clientAddress->{}, userAgent->{}", (Object)prefix, (Object)ctx.clientAddress(), (Object)request.headers().get((CharSequence)HttpHeaderNames.USER_AGENT));
    }
}

