/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import okio.Okio;
import okio.Source;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.InMemoryReporterMetrics;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Threads(value=-1)
public abstract class SenderBenchmarks {
    static final int TARGET_BACKLOG = 1000000;
    @Param(value={"65536", "500000", "5242880", "16777216"})
    public int messageMaxBytes;
    static final byte[] clientSpanBytes = SenderBenchmarks.spanFromResource("/zipkin2-client.json");
    static final Span clientSpan = (Span)SpanBytesDecoder.JSON_V2.decodeOne(clientSpanBytes);
    static final InMemoryReporterMetrics metrics = new InMemoryReporterMetrics();
    Sender sender;
    AsyncReporter.BoundedAsyncReporter<Span> reporter;

    @Setup(value=Level.Trial)
    public void setup() throws Throwable {
        this.sender = this.createSender();
        CheckResult senderCheck = this.sender.check();
        if (!senderCheck.ok()) {
            throw senderCheck.error();
        }
        this.reporter = (AsyncReporter.BoundedAsyncReporter)AsyncReporter.builder((Sender)this.sender).messageMaxBytes(this.messageMaxBytes).queuedMaxSpans(1000000).metrics((ReporterMetrics)metrics).build();
    }

    protected abstract Sender createSender() throws Exception;

    @Setup(value=Level.Iteration)
    public void fillQueue() throws IOException {
        while (this.reporter.pending.offer((Object)clientSpan, clientSpanBytes.length)) {
        }
    }

    @TearDown(value=Level.Iteration)
    public void clearQueue() throws IOException {
        this.reporter.pending.clear();
    }

    @Benchmark
    public void report(InMemoryReporterMetricsAsCounters counters) throws InterruptedException {
        if (this.reporter.pending.offer((Object)clientSpan, clientSpanBytes.length)) {
            metrics.incrementSpans(1);
        } else {
            Thread.sleep(10L);
        }
    }

    @TearDown(value=Level.Trial)
    public void close() throws Exception {
        this.reporter.close();
        this.sender.close();
        this.afterSenderClose();
    }

    protected abstract void afterSenderClose() throws Exception;

    static byte[] spanFromResource(String jsonResource) {
        InputStream stream = SenderBenchmarks.class.getResourceAsStream(jsonResource);
        try {
            return Okio.buffer((Source)Okio.source((InputStream)stream)).readByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @AuxCounters
    @State(value=Scope.Thread)
    public static class InMemoryReporterMetricsAsCounters {
        public long spans() {
            return metrics.spans() - metrics.spansDropped();
        }

        public long messages() {
            return metrics.messages();
        }

        public long messagesDropped() {
            return metrics.messagesDropped();
        }

        @Setup(value=Level.Iteration)
        public void clean() {
            metrics.clear();
        }
    }
}

