/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Server;
import java.time.Duration;
import zipkin2.reporter.Sender;
import zipkin2.reporter.SenderBenchmarks;

public abstract class HttpSenderBenchmarks
extends SenderBenchmarks {
    Server server;

    @Override
    protected Sender createSender() {
        Route v2JsonSpans = Route.builder().methods(new HttpMethod[]{HttpMethod.POST}).consumes(new MediaType[]{MediaType.JSON}).path("/api/v2/spans").build();
        this.server = Server.builder().http(0).gracefulShutdownTimeout(Duration.ZERO, Duration.ZERO).service(v2JsonSpans, (ctx, res) -> HttpResponse.of((int)202)).build();
        this.server.start().join();
        return this.newHttpSender(this.url("/api/v2/spans"));
    }

    abstract Sender newHttpSender(String var1);

    @Override
    protected void afterSenderClose() {
        this.server.stop().join();
    }

    String url(String path) {
        return this.server.activePorts().values().stream().filter(p -> p.hasProtocol(SessionProtocol.HTTP)).findAny().map(p -> "http://127.0.0.1:" + p.localAddress().getPort() + path).orElseThrow(() -> new AssertionError((Object)"http port not open"));
    }
}

