/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.autoconfigure.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import zipkin2.autoconfigure.ui.ZipkinUiProperties;

@Configuration
@EnableConfigurationProperties(value={ZipkinUiProperties.class})
@ConditionalOnProperty(name={"zipkin.ui.enabled"}, matchIfMissing=true)
@RestController
class ZipkinUiAutoConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    ZipkinUiProperties ui;
    @Value(value="classpath:zipkin-ui/index.html")
    Resource indexHtml;

    ZipkinUiAutoConfiguration() {
    }

    @Bean
    @Lazy
    String processedIndexHtml() throws IOException {
        Document soup;
        String baseTagValue = "/".equals(this.ui.getBasepath()) ? "/" : this.ui.getBasepath() + "/";
        try (InputStream is = this.indexHtml.getInputStream();){
            soup = Jsoup.parse((InputStream)is, null, (String)baseTagValue);
        }
        if (soup.head().getElementsByTag("base").isEmpty()) {
            soup.head().appendChild((Node)soup.createElement("base"));
        }
        soup.head().getElementsByTag("base").attr("href", baseTagValue);
        return soup.html();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/zipkin/**"}).addResourceLocations(new String[]{"classpath:/zipkin-ui/"}).setCachePeriod(Integer.valueOf((int)TimeUnit.DAYS.toSeconds(365L)));
    }

    @Bean
    @Order(value=-2147483648)
    public CharacterEncodingFilter characterEncodingFilter() {
        CharacterEncodingFilter filter = new CharacterEncodingFilter(){

            protected boolean shouldNotFilter(HttpServletRequest request) {
                return request.getServletPath().endsWith(".png");
            }
        };
        filter.setEncoding("UTF-8");
        filter.setForceEncoding(true);
        return filter;
    }

    @RequestMapping(value={"/zipkin/config.json"}, method={RequestMethod.GET})
    public ResponseEntity<ZipkinUiProperties> serveUiConfig() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.APPLICATION_JSON).body((Object)this.ui);
    }

    @RequestMapping(value={"/zipkin/index.html"}, method={RequestMethod.GET})
    public ResponseEntity<?> serveIndex() throws IOException {
        ResponseEntity.BodyBuilder result = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.TEXT_HTML);
        return "/zipkin".equals(this.ui.getBasepath()) ? result.body((Object)this.indexHtml) : result.body((Object)this.processedIndexHtml());
    }

    @RequestMapping(value={"/zipkin/", "/zipkin/traces/{id}", "/zipkin/dependency", "/zipkin/traceViewer"}, method={RequestMethod.GET})
    public ModelAndView forwardUiEndpoints() {
        return new ModelAndView("forward:/zipkin/index.html");
    }

    @RequestMapping(value={"/zipkin/api/**"}, method={RequestMethod.GET})
    public ModelAndView forwardApi(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        return new ModelAndView("forward:" + path.replaceFirst("/zipkin", ""));
    }

    @RequestMapping(value={"/favicon.ico"}, method={RequestMethod.GET})
    public ModelAndView favicon() {
        return new ModelAndView("forward:/zipkin/favicon.ico");
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void redirectRoot(HttpServletResponse response) {
        response.setHeader("Location", "./zipkin/");
        response.setStatus(HttpStatus.FOUND.value());
    }
}

