/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.translation.stackdriver;

import com.google.devtools.cloudtrace.v1.Trace;
import com.google.devtools.cloudtrace.v1.TraceSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import zipkin2.Span;
import zipkin2.translation.stackdriver.SpanTranslator;

public final class TraceTranslator {
    public static List<Trace> translateSpans(String projectId, Collection<Span> zipkinSpans) {
        List<Span> sortedByTraceAndSpanId = TraceTranslator.sortByTraceAndSpanId(zipkinSpans);
        Trace.Builder currentTrace = null;
        ArrayList<Trace> result = new ArrayList<Trace>();
        int length = sortedByTraceAndSpanId.size();
        for (int i = 0; i < length; ++i) {
            Span currentSpan = sortedByTraceAndSpanId.get(i);
            String traceId = currentSpan.traceId();
            if (traceId.length() == 16) {
                traceId = "0000000000000000" + traceId;
            }
            if (currentTrace == null || !traceId.equals(currentTrace.getTraceId())) {
                TraceTranslator.finishTrace(currentTrace, result);
                currentTrace = Trace.newBuilder();
                currentTrace.setProjectId(projectId);
                currentTrace.setTraceId(traceId);
            }
            TraceTranslator.appendSpan(currentTrace, currentSpan);
        }
        TraceTranslator.finishTrace(currentTrace, result);
        return result;
    }

    private static List<Span> sortByTraceAndSpanId(Collection<Span> input) {
        ArrayList<Span> result = new ArrayList<Span>(input);
        Collections.sort(result, new Comparator<Span>(){

            @Override
            public int compare(Span o1, Span o2) {
                int result = o1.traceId().compareTo(o2.traceId());
                if (result != 0) {
                    return result;
                }
                return o1.id().compareTo(o2.id());
            }
        });
        return result;
    }

    private static void appendSpan(Trace.Builder builder, Span zipkinSpan) {
        builder.addSpans(SpanTranslator.translate(TraceSpan.newBuilder(), zipkinSpan));
    }

    private static void finishTrace(Trace.Builder traceBuilder, Collection<Trace> convertedTraces) {
        if (traceBuilder != null) {
            convertedTraces.add(traceBuilder.build());
        }
    }
}

