/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.translation.stackdriver;

import com.google.devtools.cloudtrace.v1.TraceSpan;
import com.google.protobuf.Timestamp;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.Span;
import zipkin2.translation.stackdriver.LabelExtractor;

public final class SpanTranslator {
    private static final Logger LOG = Logger.getLogger(SpanTranslator.class.getName());
    static final LabelExtractor labelExtractor;

    public static TraceSpan.Builder translate(TraceSpan.Builder spanBuilder, Span zipkinSpan) {
        boolean logTranslation = LOG.isLoggable(Level.FINE);
        if (logTranslation) {
            LOG.log(Level.FINE, ">> translating zipkin span: {0}", zipkinSpan);
        }
        spanBuilder.setName(zipkinSpan.name() != null ? zipkinSpan.name() : "");
        TraceSpan.SpanKind kind = SpanTranslator.getSpanKind(zipkinSpan.kind());
        spanBuilder.setKind(kind);
        spanBuilder.setParentSpanId(SpanTranslator.parseUnsignedLong(zipkinSpan.parentId()));
        spanBuilder.setSpanId(SpanTranslator.parseUnsignedLong(zipkinSpan.id()));
        if (zipkinSpan.timestampAsLong() != 0L) {
            spanBuilder.setStartTime(SpanTranslator.createTimestamp(zipkinSpan.timestampAsLong()));
            if (zipkinSpan.durationAsLong() != 0L) {
                Timestamp endTime = SpanTranslator.createTimestamp(zipkinSpan.timestampAsLong() + zipkinSpan.durationAsLong());
                spanBuilder.setEndTime(endTime);
            }
        }
        spanBuilder.putAllLabels(labelExtractor.extract(zipkinSpan));
        if (logTranslation) {
            LOG.log(Level.FINE, "<< translated to stackdriver span: {0}", spanBuilder);
        }
        return spanBuilder;
    }

    private static long parseUnsignedLong(String lowerHex) {
        if (lowerHex == null) {
            return 0L;
        }
        long result = 0L;
        for (int i = 0; i < 16; ++i) {
            char c = lowerHex.charAt(i);
            result <<= 4;
            if (c >= '0' && c <= '9') {
                result |= (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                result |= (long)(c - 97 + 10);
                continue;
            }
            return 0L;
        }
        return result;
    }

    private static TraceSpan.SpanKind getSpanKind(Span.Kind zipkinKind) {
        if (zipkinKind == null || zipkinKind == Span.Kind.CONSUMER || zipkinKind == Span.Kind.PRODUCER) {
            return TraceSpan.SpanKind.SPAN_KIND_UNSPECIFIED;
        }
        if (zipkinKind == Span.Kind.CLIENT) {
            return TraceSpan.SpanKind.RPC_CLIENT;
        }
        if (zipkinKind == Span.Kind.SERVER) {
            return TraceSpan.SpanKind.RPC_SERVER;
        }
        return TraceSpan.SpanKind.UNRECOGNIZED;
    }

    private static Timestamp createTimestamp(long microseconds) {
        long seconds = microseconds / 1000000L;
        int remainderMicros = (int)(microseconds % 1000000L);
        int remainderNanos = remainderMicros * 1000;
        return Timestamp.newBuilder().setSeconds(seconds).setNanos(remainderNanos).build();
    }

    static {
        LinkedHashMap<String, String> renamedLabels = new LinkedHashMap<String, String>();
        renamedLabels.put("http.host", "/http/host");
        renamedLabels.put("http.method", "/http/method");
        renamedLabels.put("http.status_code", "/http/status_code");
        renamedLabels.put("http.request.size", "/request/size");
        renamedLabels.put("http.response.size", "/response/size");
        renamedLabels.put("http.url", "/http/url");
        labelExtractor = new LabelExtractor(renamedLabels);
    }
}

