/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.translation.stackdriver;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import zipkin2.Annotation;
import zipkin2.Span;

final class LabelExtractor {
    private static final String kAgentLabelKey = "/agent";
    private static final String kComponentLabelKey = "/component";
    private final Map<String, String> renamedLabels;
    static final int LABEL_LENGTH_MAX = 8192;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final ThreadLocal<SimpleDateFormat> DATE = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat result = new SimpleDateFormat("yyyy-MM-dd (HH:mm:ss.SSS)");
            result.setTimeZone(UTC);
            return result;
        }
    };

    LabelExtractor(Map<String, String> renamedLabels) {
        this.renamedLabels = renamedLabels;
    }

    Map<String, String> extract(Span zipkinSpan) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry tag : zipkinSpan.tags().entrySet()) {
            String value = (String)tag.getValue();
            if (value.length() > 8192) {
                value = value.substring(0, 8192);
            }
            result.put(this.getLabelName((String)tag.getKey()), value);
        }
        if (zipkinSpan.localEndpoint() != null && zipkinSpan.kind() == Span.Kind.SERVER) {
            if (zipkinSpan.localEndpoint().ipv4() != null) {
                result.put(this.getLabelName("endpoint.ipv4"), zipkinSpan.localEndpoint().ipv4());
            }
            if (zipkinSpan.localEndpoint().ipv6() != null) {
                result.put(this.getLabelName("endpoint.ipv6"), zipkinSpan.localEndpoint().ipv6());
            }
        }
        for (Annotation annotation : zipkinSpan.annotations()) {
            result.put(this.getLabelName(annotation.value()), LabelExtractor.formatTimestamp(annotation.timestamp()));
        }
        if (zipkinSpan.localEndpoint() != null && !zipkinSpan.localEndpoint().serviceName().isEmpty()) {
            result.put(kComponentLabelKey, zipkinSpan.localEndpoint().serviceName());
        }
        if (zipkinSpan.parentId() == null) {
            String agentName = System.getProperty("stackdriver.trace.zipkin.agent", "zipkin-java");
            result.put(kAgentLabelKey, agentName);
        }
        return result;
    }

    private String getLabelName(String zipkinName) {
        String renamed = this.renamedLabels.get(zipkinName);
        return renamed != null ? renamed : zipkinName;
    }

    static String formatTimestamp(long microseconds) {
        long milliseconds = microseconds / 1000L;
        return DATE.get().format(new Date(milliseconds));
    }
}

