/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.propagation.stackdriver;

import brave.propagation.B3Propagation;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.util.Collections;
import java.util.List;
import zipkin2.propagation.stackdriver.CompositeExtractor;
import zipkin2.propagation.stackdriver.XCloudTraceContextExtractor;

public final class StackdriverTracePropagation<K>
implements Propagation<K> {
    public static final Propagation.Factory FACTORY = new Propagation.Factory(){

        public <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
            return new StackdriverTracePropagation<K>(keyFactory);
        }

        public boolean supportsJoin() {
            return false;
        }

        public boolean requires128BitTraceId() {
            return true;
        }

        public String toString() {
            return "StackdriverTracePropagationFactory";
        }
    };
    static final String TRACE_ID_NAME = "x-cloud-trace-context";
    final Propagation<K> b3Propagation;
    final K traceIdKey;
    final List<K> fields;

    StackdriverTracePropagation(Propagation.KeyFactory<K> keyFactory) {
        this.traceIdKey = keyFactory.create(TRACE_ID_NAME);
        this.fields = Collections.singletonList(this.traceIdKey);
        this.b3Propagation = B3Propagation.FACTORY.create(keyFactory);
    }

    public K getTraceIdKey() {
        return this.traceIdKey;
    }

    public List<K> keys() {
        return this.fields;
    }

    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter) {
        return this.b3Propagation.injector(setter);
    }

    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter) {
        if (getter == null) {
            throw new NullPointerException("getter == null");
        }
        return CompositeExtractor.create(this.b3Propagation.extractor(getter), new XCloudTraceContextExtractor<C, K>(this, getter));
    }
}

