/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.propagation.stackdriver;

import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;

final class CompositeExtractor<C>
implements TraceContext.Extractor<C> {
    final TraceContext.Extractor<C>[] extractors;

    static <C> CompositeExtractor<C> create(TraceContext.Extractor<C> ... extractors) {
        if (extractors == null) {
            throw new NullPointerException("extractors == null");
        }
        if (extractors.length == 0) {
            throw new NullPointerException("extractors are empty ");
        }
        TraceContext.Extractor[] extractorsCopy = new TraceContext.Extractor[extractors.length];
        System.arraycopy(extractors, 0, extractorsCopy, 0, extractors.length);
        return new CompositeExtractor<C>(extractorsCopy);
    }

    CompositeExtractor(TraceContext.Extractor<C> ... extractors) {
        this.extractors = extractors;
    }

    public TraceContextOrSamplingFlags extract(C carrier) {
        TraceContextOrSamplingFlags context = TraceContextOrSamplingFlags.EMPTY;
        int currentExtractor = 0;
        while (context == TraceContextOrSamplingFlags.EMPTY && currentExtractor < this.extractors.length) {
            context = this.extractors[currentExtractor++].extract(carrier);
        }
        return context;
    }
}

