/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.internal.WriteBuffer;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Thread)
@Threads(value=1)
public class WriteBufferBenchmarks {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final String CHINESE_UTF8 = "\u8ba2\u5355d07c4daa-0fa9-4c03-90b1-e06c4edae250\u4e0d\u5b58\u5728";
    static final int CHINESE_UTF8_SIZE = UTF_8.encode("\u8ba2\u5355d07c4daa-0fa9-4c03-90b1-e06c4edae250\u4e0d\u5b58\u5728").remaining();
    static final int TEST_INT = 1024;
    static final long TEST_LONG = 1472470996199000L;
    byte[] bytes = new byte[8];
    WriteBuffer buffer = WriteBuffer.wrap((byte[])this.bytes);

    @Benchmark
    public int utf8SizeInBytes_chinese() {
        return WriteBuffer.utf8SizeInBytes((CharSequence)CHINESE_UTF8);
    }

    @Benchmark
    public byte[] writeUtf8_chinese() {
        byte[] bytesUtf8 = new byte[CHINESE_UTF8_SIZE];
        WriteBuffer.wrap((byte[])bytesUtf8, (int)0).writeUtf8((CharSequence)CHINESE_UTF8);
        return bytesUtf8;
    }

    @Benchmark
    public ByteBuffer writeUtf8_chinese_jdk() {
        return UTF_8.encode(CHINESE_UTF8);
    }

    @Benchmark
    public int varIntSizeInBytes_32() {
        return WriteBuffer.varintSizeInBytes((int)1024);
    }

    @Benchmark
    public int varIntSizeInBytes_64() {
        return WriteBuffer.varintSizeInBytes((long)1472470996199000L);
    }

    @Benchmark
    public int writeVarint_32() {
        this.buffer.writeVarint(1024);
        return this.buffer.pos();
    }

    @Benchmark
    public int writeVarint_64() {
        this.buffer.writeVarint(1472470996199000L);
        return this.buffer.pos();
    }

    @Benchmark
    public int writeLongLe() {
        this.buffer.writeLongLe(1472470996199000L);
        return this.buffer.pos();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + WriteBufferBenchmarks.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }
}

