/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.SampleTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Thread)
@Threads(value=1)
public class ReadBufferBenchmarks {
    byte[] longBuff = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};

    @Benchmark
    public long readLong() {
        int pos = 0;
        return ((long)this.longBuff[pos] & 0xFFL) << 56 | ((long)this.longBuff[pos + 1] & 0xFFL) << 48 | ((long)this.longBuff[pos + 2] & 0xFFL) << 40 | ((long)this.longBuff[pos + 3] & 0xFFL) << 32 | ((long)this.longBuff[pos + 4] & 0xFFL) << 24 | ((long)this.longBuff[pos + 5] & 0xFFL) << 16 | ((long)this.longBuff[pos + 6] & 0xFFL) << 8 | (long)this.longBuff[pos + 7] & 0xFFL;
    }

    @Benchmark
    public long readLong_localArray() {
        int pos = 0;
        byte[] longBuff = this.longBuff;
        return ((long)longBuff[pos] & 0xFFL) << 56 | ((long)longBuff[pos + 1] & 0xFFL) << 48 | ((long)longBuff[pos + 2] & 0xFFL) << 40 | ((long)longBuff[pos + 3] & 0xFFL) << 32 | ((long)longBuff[pos + 4] & 0xFFL) << 24 | ((long)longBuff[pos + 5] & 0xFFL) << 16 | ((long)longBuff[pos + 6] & 0xFFL) << 8 | (long)longBuff[pos + 7] & 0xFFL;
    }

    @Benchmark
    public long readLong_8arity_localArray() {
        int pos = 0;
        return ReadBufferBenchmarks.readLong(this.longBuff[pos] & 0xFF, this.longBuff[pos + 1] & 0xFF, this.longBuff[pos + 2] & 0xFF, this.longBuff[pos + 3] & 0xFF, this.longBuff[pos + 4] & 0xFF, this.longBuff[pos + 5] & 0xFF, this.longBuff[pos + 6] & 0xFF, this.longBuff[pos + 7] & 0xFF);
    }

    @Benchmark
    public long readLong_8arity() {
        int pos = 0;
        byte[] longBuff = this.longBuff;
        return ReadBufferBenchmarks.readLong(longBuff[pos] & 0xFF, longBuff[pos + 1] & 0xFF, longBuff[pos + 2] & 0xFF, longBuff[pos + 3] & 0xFF, longBuff[pos + 4] & 0xFF, longBuff[pos + 5] & 0xFF, longBuff[pos + 6] & 0xFF, longBuff[pos + 7] & 0xFF);
    }

    static long readLong(int p0, int p1, int p2, int p3, int p4, int p5, int p6, int p7) {
        return ((long)p0 & 0xFFL) << 56 | ((long)p1 & 0xFFL) << 48 | ((long)p2 & 0xFFL) << 40 | ((long)p3 & 0xFFL) << 32 | ((long)p4 & 0xFFL) << 24 | ((long)p5 & 0xFFL) << 16 | ((long)p6 & 0xFFL) << 8 | (long)p7 & 0xFFL;
    }

    @Benchmark
    public long readLongReverseBytes() {
        return Long.reverseBytes(this.readLong());
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + ReadBufferBenchmarks.class.getSimpleName() + ".*").addProfiler("gc").build();
        new Runner(opt).run();
    }
}

