/*
 * Decompiled with CFR 0.152.
 */
package zipkin.module.aws.xray;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin.module.aws.xray.ZipkinXRayStorageProperties;
import zipkin2.storage.StorageComponent;

@Configuration
@EnableConfigurationProperties(value={ZipkinXRayStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="xray")
@ConditionalOnMissingBean(value={StorageComponent.class})
class ZipkinXRayStorageModule {
    ZipkinXRayStorageModule() {
    }

    @Bean
    @ConditionalOnMissingBean
    StorageComponent storage(ZipkinXRayStorageProperties properties, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId) {
        return properties.toBuilder().strictTraceId(strictTraceId).build();
    }
}

