/*
 * Decompiled with CFR 0.152.
 */
package brave.instrumentation.awsv2;

import brave.http.HttpClientAdapter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;

class HttpAdapter
extends HttpClientAdapter<SdkHttpRequest.Builder, SdkHttpResponse> {
    HttpAdapter() {
    }

    public String method(SdkHttpRequest.Builder builder) {
        return builder.method().name();
    }

    public String path(SdkHttpRequest.Builder request) {
        return request.encodedPath();
    }

    public String url(SdkHttpRequest.Builder request) {
        StringBuilder url = new StringBuilder(request.protocol()).append("://").append(request.host()).append(":").append(request.port());
        if (request.encodedPath() != null) {
            url.append(request.encodedPath());
        }
        if (request.rawQueryParameters().isEmpty()) {
            return url.toString();
        }
        url.append('?');
        Iterator entries = request.rawQueryParameters().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            url.append((String)entry.getKey());
            if (((String)entry.getKey()).isEmpty()) continue;
            url.append('=').append((String)((List)entry.getValue()).get(0));
            if (!entries.hasNext()) continue;
            url.append('&');
        }
        return url.toString();
    }

    public String requestHeader(SdkHttpRequest.Builder builder, String s) {
        return (String)((List)builder.headers().get(s)).get(0);
    }

    public Integer statusCode(SdkHttpResponse sdkHttpResponse) {
        return sdkHttpResponse.statusCode();
    }
}

