/*
 * Decompiled with CFR 0.152.
 */
package brave.instrumentation.aws;

import brave.http.HttpTracing;
import brave.instrumentation.aws.TracingRequestHandler;
import brave.propagation.CurrentTraceContext;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.client.builder.ExecutorFactory;
import com.amazonaws.handlers.RequestHandler2;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class AwsClientTracing {
    static final ClientConfigurationFactory defaultClientConfigurationFactory = new ClientConfigurationFactory();
    final HttpTracing httpTracing;
    final CurrentTraceContext currentTraceContext;

    public static AwsClientTracing create(HttpTracing httpTracing) {
        return new AwsClientTracing(httpTracing);
    }

    AwsClientTracing(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        this.httpTracing = httpTracing;
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
    }

    public <Builder extends AwsClientBuilder, Client> Client build(AwsClientBuilder<Builder, Client> builder) {
        if (builder == null) {
            throw new NullPointerException("builder == null");
        }
        if (builder instanceof AwsAsyncClientBuilder) {
            ExecutorFactory executorFactory = ((AwsAsyncClientBuilder)builder).getExecutorFactory();
            if (executorFactory == null) {
                ClientConfiguration clientConfiguration = builder.getClientConfiguration();
                if (clientConfiguration == null) {
                    clientConfiguration = defaultClientConfigurationFactory.getConfig();
                }
                ((AwsAsyncClientBuilder)builder).setExecutorFactory((ExecutorFactory)new TracingExecutorFactory(this.currentTraceContext, clientConfiguration));
            } else {
                ((AwsAsyncClientBuilder)builder).setExecutorFactory((ExecutorFactory)new TracingExecutorFactoryWrapper(this.currentTraceContext, executorFactory));
            }
        }
        builder.withRequestHandlers(new RequestHandler2[]{new TracingRequestHandler(this.httpTracing)});
        return (Client)builder.build();
    }

    static final class TracingExecutorFactory
    implements ExecutorFactory {
        final CurrentTraceContext currentTraceContext;
        final ExecutorService executorService;

        TracingExecutorFactory(CurrentTraceContext currentTraceContext, ClientConfiguration clientConfiguration) {
            this.currentTraceContext = currentTraceContext;
            this.executorService = Executors.newFixedThreadPool(clientConfiguration.getMaxConnections());
        }

        public ExecutorService newExecutor() {
            return this.currentTraceContext.executorService(this.executorService);
        }
    }

    static final class TracingExecutorFactoryWrapper
    implements ExecutorFactory {
        final CurrentTraceContext currentTraceContext;
        final ExecutorFactory delegate;

        TracingExecutorFactoryWrapper(CurrentTraceContext currentTraceContext, ExecutorFactory delegate) {
            this.currentTraceContext = currentTraceContext;
            this.delegate = delegate;
        }

        public ExecutorService newExecutor() {
            return this.currentTraceContext.executorService(this.delegate.newExecutor());
        }
    }

    static final class HttpClientResponse
    extends brave.http.HttpClientResponse {
        final Response<?> delegate;

        HttpClientResponse(Response<?> delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            return this.delegate.getHttpResponse().getStatusCode();
        }
    }

    static final class HttpClientRequest
    extends brave.http.HttpClientRequest {
        final Request<?> delegate;

        HttpClientRequest(Request<?> delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getHttpMethod().name();
        }

        public String path() {
            return this.delegate.getResourcePath();
        }

        public String url() {
            StringBuilder url = new StringBuilder(this.delegate.getEndpoint().toString());
            if (this.delegate.getResourcePath() != null) {
                url.append(this.delegate.getResourcePath());
            }
            if (this.delegate.getParameters().isEmpty()) {
                return url.toString();
            }
            url.append('?');
            Iterator entries = this.delegate.getParameters().entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                url.append((String)entry.getKey());
                if (((String)entry.getKey()).isEmpty()) continue;
                url.append('=').append((String)((List)entry.getValue()).get(0));
                if (!entries.hasNext()) continue;
                url.append('&');
            }
            return url.toString();
        }

        public String header(String name) {
            return (String)this.delegate.getHeaders().get(name);
        }

        public void header(String name, String value) {
            this.delegate.addHeader(name, value);
        }
    }
}

