/*
 * Decompiled with CFR 0.152.
 */
package brave.instrumentation.aws;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.instrumentation.aws.HttpAdapter;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.handlers.HandlerAfterAttemptContext;
import com.amazonaws.handlers.HandlerBeforeAttemptContext;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;

final class TracingRequestHandler
extends RequestHandler2 {
    static final HandlerContextKey<Span> APPLICATION_SPAN = new HandlerContextKey("APPLICATION_SPAN");
    static final HandlerContextKey<TraceContext> DEFERRED_ROOT_CONTEXT = new HandlerContextKey("DEFERRED_ROOT_CONTEXT");
    static final HandlerContextKey<Span> CLIENT_SPAN = new HandlerContextKey(Span.class.getCanonicalName());
    static final HttpClientAdapter<Request<?>, Response<?>> ADAPTER = new HttpAdapter();
    static final Propagation.Setter<Request<?>, String> SETTER = new Propagation.Setter<Request<?>, String>(){

        public void put(Request<?> carrier, String key, String value) {
            carrier.addHeader(key, value);
        }
    };
    final HttpTracing httpTracing;
    final Tracer tracer;
    final HttpClientHandler<Request<?>, Response<?>> handler;
    final TraceContext.Injector<Request<?>> injector;

    TracingRequestHandler(HttpTracing httpTracing) {
        this.httpTracing = httpTracing;
        this.tracer = httpTracing.tracing().tracer();
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, ADAPTER);
    }

    public AmazonWebServiceRequest beforeExecution(AmazonWebServiceRequest request) {
        Span applicationSpan = this.tracer.nextSpan();
        if (applicationSpan.context().parentIdAsLong() == 0L) {
            request.addHandlerContext(DEFERRED_ROOT_CONTEXT, (Object)applicationSpan.context());
        } else {
            request.addHandlerContext(APPLICATION_SPAN, (Object)applicationSpan.start());
        }
        return request;
    }

    public void beforeAttempt(HandlerBeforeAttemptContext context) {
        Span applicationSpan;
        TraceContext deferredRootContext = (TraceContext)context.getRequest().getHandlerContext(DEFERRED_ROOT_CONTEXT);
        if (deferredRootContext != null) {
            Boolean sampled = this.httpTracing.clientSampler().trySample(ADAPTER, (Object)context.getRequest());
            if (sampled == null) {
                sampled = this.httpTracing.tracing().sampler().isSampled(deferredRootContext.traceId());
            }
            applicationSpan = this.tracer.toSpan(deferredRootContext.toBuilder().sampled(sampled).build());
            context.getRequest().addHandlerContext(APPLICATION_SPAN, (Object)applicationSpan.start());
        } else {
            applicationSpan = (Span)context.getRequest().getHandlerContext(APPLICATION_SPAN);
        }
        if (applicationSpan == null) {
            return;
        }
        String operation = this.getAwsOperationFromRequest(context.getRequest());
        applicationSpan.name("aws-sdk").tag("aws.service_name", context.getRequest().getServiceName()).tag("aws.operation", operation);
        Span clientSpan = this.nextClientSpan(context.getRequest(), applicationSpan, operation);
        context.getRequest().addHandlerContext(CLIENT_SPAN, (Object)clientSpan);
    }

    public final void afterAttempt(HandlerAfterAttemptContext context) {
        Span clientSpan = (Span)context.getRequest().getHandlerContext(CLIENT_SPAN);
        if (clientSpan == null) {
            return;
        }
        if (context.getException() != null && context.getException() instanceof AmazonServiceException) {
            TracingRequestHandler.tagSpanWithRequestId(clientSpan, (AmazonServiceException)context.getException());
        } else {
            TracingRequestHandler.tagSpanWithRequestId(clientSpan, context.getResponse());
        }
        this.handler.handleReceive((Object)context.getResponse(), (Throwable)context.getException(), clientSpan);
    }

    public final void afterResponse(Request<?> request, Response<?> response) {
        Span applicationSpan = (Span)request.getHandlerContext(APPLICATION_SPAN);
        if (applicationSpan != null) {
            applicationSpan.finish();
        }
    }

    public final void afterError(Request<?> request, Response<?> response, Exception e) {
        Span applicationSpan = (Span)request.getHandlerContext(APPLICATION_SPAN);
        if (applicationSpan != null) {
            applicationSpan.error((Throwable)e);
            applicationSpan.finish();
        }
    }

    private Span nextClientSpan(Request<?> request, Span applicationSpan, String operation) {
        Span span = this.tracer.newChild(applicationSpan.context());
        this.handler.handleSend(this.injector, request, span);
        return span.name(operation).remoteServiceName(request.getServiceName());
    }

    private String getAwsOperationFromRequest(Request<?> request) {
        String operation = request.getOriginalRequest().getClass().getSimpleName();
        if (operation.endsWith("Request")) {
            return operation.substring(0, operation.length() - 7);
        }
        return operation;
    }

    static void tagSpanWithRequestId(Span span, Response response) {
        String requestId = null;
        if (response != null) {
            if (response.getAwsResponse() instanceof AmazonWebServiceResult) {
                ResponseMetadata metadata = ((AmazonWebServiceResult)response.getAwsResponse()).getSdkResponseMetadata();
                if (null != metadata) {
                    requestId = metadata.getRequestId();
                }
            } else if (response.getHttpResponse() != null && response.getHttpResponse().getHeader("x-amz-request-id") != null) {
                requestId = response.getHttpResponse().getHeader("x-amz-request-id");
            }
        }
        if (requestId != null) {
            span.tag("aws.request_id", requestId);
        }
    }

    static void tagSpanWithRequestId(Span span, AmazonServiceException exception) {
        String requestId = exception.getRequestId();
        if (requestId != null) {
            span.tag("aws.request_id", requestId);
        }
    }
}

