package io.zeebe.exporter.record;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RecordMetadata} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractRecordMetadataAssert<S extends AbstractRecordMetadataAssert<S, A>, A extends RecordMetadata> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRecordMetadataAssert}</code> to make assertions on actual RecordMetadata.
   * @param actual the RecordMetadata we want to make assertions on.
   */
  protected AbstractRecordMetadataAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RecordMetadata's intent is equal to the given one.
   * @param intent the given intent to compare the actual RecordMetadata's intent to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecordMetadata's intent is not equal to the given one.
   */
  public S hasIntent(io.zeebe.protocol.intent.Intent intent) {
    // check that actual RecordMetadata we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting intent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    io.zeebe.protocol.intent.Intent actualIntent = actual.getIntent();
    if (!Objects.areEqual(actualIntent, intent)) {
      failWithMessage(assertjErrorMessage, actual, intent, actualIntent);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RecordMetadata's partitionId is equal to the given one.
   * @param partitionId the given partitionId to compare the actual RecordMetadata's partitionId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecordMetadata's partitionId is not equal to the given one.
   */
  public S hasPartitionId(int partitionId) {
    // check that actual RecordMetadata we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting partitionId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualPartitionId = actual.getPartitionId();
    if (actualPartitionId != partitionId) {
      failWithMessage(assertjErrorMessage, actual, partitionId, actualPartitionId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RecordMetadata's recordType is equal to the given one.
   * @param recordType the given recordType to compare the actual RecordMetadata's recordType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecordMetadata's recordType is not equal to the given one.
   */
  public S hasRecordType(io.zeebe.protocol.clientapi.RecordType recordType) {
    // check that actual RecordMetadata we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting recordType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    io.zeebe.protocol.clientapi.RecordType actualRecordType = actual.getRecordType();
    if (!Objects.areEqual(actualRecordType, recordType)) {
      failWithMessage(assertjErrorMessage, actual, recordType, actualRecordType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RecordMetadata's rejectionReason is equal to the given one.
   * @param rejectionReason the given rejectionReason to compare the actual RecordMetadata's rejectionReason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecordMetadata's rejectionReason is not equal to the given one.
   */
  public S hasRejectionReason(String rejectionReason) {
    // check that actual RecordMetadata we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting rejectionReason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualRejectionReason = actual.getRejectionReason();
    if (!Objects.areEqual(actualRejectionReason, rejectionReason)) {
      failWithMessage(assertjErrorMessage, actual, rejectionReason, actualRejectionReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RecordMetadata's rejectionType is equal to the given one.
   * @param rejectionType the given rejectionType to compare the actual RecordMetadata's rejectionType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecordMetadata's rejectionType is not equal to the given one.
   */
  public S hasRejectionType(io.zeebe.protocol.clientapi.RejectionType rejectionType) {
    // check that actual RecordMetadata we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting rejectionType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    io.zeebe.protocol.clientapi.RejectionType actualRejectionType = actual.getRejectionType();
    if (!Objects.areEqual(actualRejectionType, rejectionType)) {
      failWithMessage(assertjErrorMessage, actual, rejectionType, actualRejectionType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RecordMetadata's valueType is equal to the given one.
   * @param valueType the given valueType to compare the actual RecordMetadata's valueType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecordMetadata's valueType is not equal to the given one.
   */
  public S hasValueType(io.zeebe.protocol.clientapi.ValueType valueType) {
    // check that actual RecordMetadata we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting valueType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    io.zeebe.protocol.clientapi.ValueType actualValueType = actual.getValueType();
    if (!Objects.areEqual(actualValueType, valueType)) {
      failWithMessage(assertjErrorMessage, actual, valueType, actualValueType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
