/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporter.record.value;

import io.zeebe.exporter.record.value.RaftRecordValue;
import io.zeebe.exporter.record.value.raft.RaftMember;
import java.util.Collection;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;

public abstract class AbstractRaftRecordValueAssert<S extends AbstractRaftRecordValueAssert<S, A>, A extends RaftRecordValue>
extends AbstractObjectAssert<S, A> {
    protected AbstractRaftRecordValueAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasMembers(RaftMember ... members) {
        this.isNotNull();
        if (members == null) {
            this.failWithMessage("Expecting members parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((RaftRecordValue)this.actual).getMembers(), (Object[])members);
        return (S)((Object)((AbstractRaftRecordValueAssert)this.myself));
    }

    public S hasMembers(Collection<? extends RaftMember> members) {
        this.isNotNull();
        if (members == null) {
            this.failWithMessage("Expecting members parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractRaftRecordValueAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((RaftRecordValue)this.actual).getMembers(), members.toArray());
        return (S)((Object)((AbstractRaftRecordValueAssert)this.myself));
    }

    public S hasOnlyMembers(RaftMember ... members) {
        this.isNotNull();
        if (members == null) {
            this.failWithMessage("Expecting members parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((RaftRecordValue)this.actual).getMembers(), (Object[])members);
        return (S)((Object)((AbstractRaftRecordValueAssert)this.myself));
    }

    public S hasOnlyMembers(Collection<? extends RaftMember> members) {
        this.isNotNull();
        if (members == null) {
            this.failWithMessage("Expecting members parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractRaftRecordValueAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((RaftRecordValue)this.actual).getMembers(), members.toArray());
        return (S)((Object)((AbstractRaftRecordValueAssert)this.myself));
    }

    public S doesNotHaveMembers(RaftMember ... members) {
        this.isNotNull();
        if (members == null) {
            this.failWithMessage("Expecting members parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((RaftRecordValue)this.actual).getMembers(), (Object[])members);
        return (S)((Object)((AbstractRaftRecordValueAssert)this.myself));
    }

    public S doesNotHaveMembers(Collection<? extends RaftMember> members) {
        this.isNotNull();
        if (members == null) {
            this.failWithMessage("Expecting members parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractRaftRecordValueAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((RaftRecordValue)this.actual).getMembers(), members.toArray());
        return (S)((Object)((AbstractRaftRecordValueAssert)this.myself));
    }

    public S hasNoMembers() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have members but had :\n  <%s>";
        if (((RaftRecordValue)this.actual).getMembers().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((RaftRecordValue)this.actual).getMembers()});
        }
        return (S)((Object)((AbstractRaftRecordValueAssert)this.myself));
    }
}

