/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporter.record;

import io.zeebe.exporter.record.RecordMetadata;
import io.zeebe.protocol.clientapi.RecordType;
import io.zeebe.protocol.clientapi.RejectionType;
import io.zeebe.protocol.clientapi.ValueType;
import io.zeebe.protocol.intent.Intent;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractRecordMetadataAssert<S extends AbstractRecordMetadataAssert<S, A>, A extends RecordMetadata>
extends AbstractObjectAssert<S, A> {
    protected AbstractRecordMetadataAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasIntent(Intent intent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting intent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Intent actualIntent = ((RecordMetadata)this.actual).getIntent();
        if (!Objects.areEqual((Object)actualIntent, (Object)intent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, intent, actualIntent});
        }
        return (S)((Object)((AbstractRecordMetadataAssert)this.myself));
    }

    public S hasPartitionId(int partitionId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting partitionId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualPartitionId = ((RecordMetadata)this.actual).getPartitionId();
        if (actualPartitionId != partitionId) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, partitionId, actualPartitionId});
        }
        return (S)((Object)((AbstractRecordMetadataAssert)this.myself));
    }

    public S hasRecordType(RecordType recordType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting recordType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        RecordType actualRecordType = ((RecordMetadata)this.actual).getRecordType();
        if (!Objects.areEqual((Object)actualRecordType, (Object)recordType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, recordType, actualRecordType});
        }
        return (S)((Object)((AbstractRecordMetadataAssert)this.myself));
    }

    public S hasRejectionReason(String rejectionReason) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting rejectionReason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualRejectionReason = ((RecordMetadata)this.actual).getRejectionReason();
        if (!Objects.areEqual((Object)actualRejectionReason, (Object)rejectionReason)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, rejectionReason, actualRejectionReason});
        }
        return (S)((Object)((AbstractRecordMetadataAssert)this.myself));
    }

    public S hasRejectionType(RejectionType rejectionType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting rejectionType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        RejectionType actualRejectionType = ((RecordMetadata)this.actual).getRejectionType();
        if (!Objects.areEqual((Object)actualRejectionType, (Object)rejectionType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, rejectionType, actualRejectionType});
        }
        return (S)((Object)((AbstractRecordMetadataAssert)this.myself));
    }

    public S hasValueType(ValueType valueType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting valueType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ValueType actualValueType = ((RecordMetadata)this.actual).getValueType();
        if (!Objects.areEqual((Object)actualValueType, (Object)valueType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, valueType, actualValueType});
        }
        return (S)((Object)((AbstractRecordMetadataAssert)this.myself));
    }
}

