/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporter.record;

import io.zeebe.exporter.record.Record;
import io.zeebe.exporter.record.RecordMetadata;
import io.zeebe.exporter.record.RecordValue;
import java.time.Instant;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractRecordAssert<S extends AbstractRecordAssert<S, A>, A extends Record>
extends AbstractObjectAssert<S, A> {
    protected AbstractRecordAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasKey(long key) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting key of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualKey = ((Record)this.actual).getKey();
        if (actualKey != key) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, key, actualKey});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasMetadata(RecordMetadata metadata) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        RecordMetadata actualMetadata = ((Record)this.actual).getMetadata();
        if (!Objects.areEqual((Object)actualMetadata, (Object)metadata)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metadata, actualMetadata});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasPosition(long position) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting position of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualPosition = ((Record)this.actual).getPosition();
        if (actualPosition != position) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, position, actualPosition});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasProducerId(int producerId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting producerId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualProducerId = ((Record)this.actual).getProducerId();
        if (actualProducerId != producerId) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, producerId, actualProducerId});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasRaftTerm(int raftTerm) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting raftTerm of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualRaftTerm = ((Record)this.actual).getRaftTerm();
        if (actualRaftTerm != raftTerm) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, raftTerm, actualRaftTerm});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasSourceRecordPosition(long sourceRecordPosition) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting sourceRecordPosition of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualSourceRecordPosition = ((Record)this.actual).getSourceRecordPosition();
        if (actualSourceRecordPosition != sourceRecordPosition) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sourceRecordPosition, actualSourceRecordPosition});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasTimestamp(Instant timestamp) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting timestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Instant actualTimestamp = ((Record)this.actual).getTimestamp();
        if (!Objects.areEqual((Object)actualTimestamp, (Object)timestamp)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, timestamp, actualTimestamp});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasValue(RecordValue value) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        RecordValue actualValue = ((Record)this.actual).getValue();
        if (!Objects.areEqual((Object)actualValue, (Object)value)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, value, actualValue});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }
}

