package io.zeebe.exporter.record.value.raft;

import org.assertj.core.api.AbstractObjectAssert;

/**
 * Abstract base class for {@link RaftMember} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractRaftMemberAssert<S extends AbstractRaftMemberAssert<S, A>, A extends RaftMember> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRaftMemberAssert}</code> to make assertions on actual RaftMember.
   * @param actual the RaftMember we want to make assertions on.
   */
  protected AbstractRaftMemberAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RaftMember's nodeId is equal to the given one.
   * @param nodeId the given nodeId to compare the actual RaftMember's nodeId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RaftMember's nodeId is not equal to the given one.
   */
  public S hasNodeId(int nodeId) {
    // check that actual RaftMember we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting nodeId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualNodeId = actual.getNodeId();
    if (actualNodeId != nodeId) {
      failWithMessage(assertjErrorMessage, actual, nodeId, actualNodeId);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
