package io.zeebe.exporter.record.value.deployment;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentResource} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractDeploymentResourceAssert<S extends AbstractDeploymentResourceAssert<S, A>, A extends DeploymentResource> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentResourceAssert}</code> to make assertions on actual DeploymentResource.
   * @param actual the DeploymentResource we want to make assertions on.
   */
  protected AbstractDeploymentResourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentResource's resource contains the given byte elements.
   * @param resource the given elements that should be contained in actual DeploymentResource's resource.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentResource's resource does not contain all given byte elements.
   */
  public S hasResource(byte... resource) {
    // check that actual DeploymentResource we want to make assertions on is not null.
    isNotNull();

    // check that given byte varargs is not null.
    if (resource == null) failWithMessage("Expecting resource parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Assertions.assertThat(actual.getResource()).contains(resource);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentResource's resource contains <b>only</b> the given byte elements and nothing else in whatever order.
   *
   * @param resource the given elements that should be contained in actual DeploymentResource's resource.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentResource's resource does not contain all given byte elements and nothing else.
   */
  public S hasOnlyResource(byte... resource) {
    // check that actual DeploymentResource we want to make assertions on is not null.
    isNotNull();

    // check that given byte varargs is not null.
    if (resource == null) failWithMessage("Expecting resource parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Assertions.assertThat(actual.getResource()).containsOnly(resource);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentResource's resource does not contain the given byte elements.
   *
   * @param resource the given elements that should not be in actual DeploymentResource's resource.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentResource's resource contains any given byte elements.
   */
  public S doesNotHaveResource(byte... resource) {
    // check that actual DeploymentResource we want to make assertions on is not null.
    isNotNull();

    // check that given byte varargs is not null.
    if (resource == null) failWithMessage("Expecting resource parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Assertions.assertThat(actual.getResource()).doesNotContain(resource);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentResource has no resource.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentResource's resource is not empty.
   */
  public S hasNoResource() {
    // check that actual DeploymentResource we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resource but had :\n  <%s>";

    // check that it is not empty
    if (actual.getResource().length > 0)  {
      failWithMessage(assertjErrorMessage, actual, java.util.Arrays.toString(actual.getResource()));
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual DeploymentResource's resourceName is equal to the given one.
   * @param resourceName the given resourceName to compare the actual DeploymentResource's resourceName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentResource's resourceName is not equal to the given one.
   */
  public S hasResourceName(String resourceName) {
    // check that actual DeploymentResource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualResourceName = actual.getResourceName();
    if (!Objects.areEqual(actualResourceName, resourceName)) {
      failWithMessage(assertjErrorMessage, actual, resourceName, actualResourceName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentResource's resourceType is equal to the given one.
   * @param resourceType the given resourceType to compare the actual DeploymentResource's resourceType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentResource's resourceType is not equal to the given one.
   */
  public S hasResourceType(ResourceType resourceType) {
    // check that actual DeploymentResource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resourceType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    ResourceType actualResourceType = actual.getResourceType();
    if (!Objects.areEqual(actualResourceType, resourceType)) {
      failWithMessage(assertjErrorMessage, actual, resourceType, actualResourceType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
