package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link WorkflowInstanceCreationRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractWorkflowInstanceCreationRecordValueAssert<S extends AbstractWorkflowInstanceCreationRecordValueAssert<S, A>, A extends WorkflowInstanceCreationRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWorkflowInstanceCreationRecordValueAssert}</code> to make assertions on actual WorkflowInstanceCreationRecordValue.
   * @param actual the WorkflowInstanceCreationRecordValue we want to make assertions on.
   */
  protected AbstractWorkflowInstanceCreationRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual WorkflowInstanceCreationRecordValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual WorkflowInstanceCreationRecordValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceCreationRecordValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual WorkflowInstanceCreationRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceCreationRecordValue's instanceKey is equal to the given one.
   * @param instanceKey the given instanceKey to compare the actual WorkflowInstanceCreationRecordValue's instanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceCreationRecordValue's instanceKey is not equal to the given one.
   */
  public S hasInstanceKey(long instanceKey) {
    // check that actual WorkflowInstanceCreationRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting instanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualInstanceKey = actual.getInstanceKey();
    if (actualInstanceKey != instanceKey) {
      failWithMessage(assertjErrorMessage, actual, instanceKey, actualInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceCreationRecordValue's key is equal to the given one.
   * @param key the given key to compare the actual WorkflowInstanceCreationRecordValue's key to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceCreationRecordValue's key is not equal to the given one.
   */
  public S hasKey(long key) {
    // check that actual WorkflowInstanceCreationRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting key of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualKey = actual.getKey();
    if (actualKey != key) {
      failWithMessage(assertjErrorMessage, actual, key, actualKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceCreationRecordValue's variables is equal to the given one.
   * @param variables the given variables to compare the actual WorkflowInstanceCreationRecordValue's variables to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceCreationRecordValue's variables is not equal to the given one.
   */
  public S hasVariables(java.util.Map variables) {
    // check that actual WorkflowInstanceCreationRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting variables of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.util.Map actualVariables = actual.getVariables();
    if (!Objects.areEqual(actualVariables, variables)) {
      failWithMessage(assertjErrorMessage, actual, variables, actualVariables);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceCreationRecordValue's version is equal to the given one.
   * @param version the given version to compare the actual WorkflowInstanceCreationRecordValue's version to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceCreationRecordValue's version is not equal to the given one.
   */
  public S hasVersion(int version) {
    // check that actual WorkflowInstanceCreationRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualVersion = actual.getVersion();
    if (actualVersion != version) {
      failWithMessage(assertjErrorMessage, actual, version, actualVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
