package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link VariableDocumentRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractVariableDocumentRecordValueAssert<S extends AbstractVariableDocumentRecordValueAssert<S, A>, A extends VariableDocumentRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVariableDocumentRecordValueAssert}</code> to make assertions on actual VariableDocumentRecordValue.
   * @param actual the VariableDocumentRecordValue we want to make assertions on.
   */
  protected AbstractVariableDocumentRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual VariableDocumentRecordValue's document is equal to the given one.
   * @param document the given document to compare the actual VariableDocumentRecordValue's document to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VariableDocumentRecordValue's document is not equal to the given one.
   */
  public S hasDocument(java.util.Map document) {
    // check that actual VariableDocumentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting document of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.util.Map actualDocument = actual.getDocument();
    if (!Objects.areEqual(actualDocument, document)) {
      failWithMessage(assertjErrorMessage, actual, document, actualDocument);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VariableDocumentRecordValue's scopeKey is equal to the given one.
   * @param scopeKey the given scopeKey to compare the actual VariableDocumentRecordValue's scopeKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VariableDocumentRecordValue's scopeKey is not equal to the given one.
   */
  public S hasScopeKey(long scopeKey) {
    // check that actual VariableDocumentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting scopeKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualScopeKey = actual.getScopeKey();
    if (actualScopeKey != scopeKey) {
      failWithMessage(assertjErrorMessage, actual, scopeKey, actualScopeKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VariableDocumentRecordValue's updateSemantics is equal to the given one.
   * @param updateSemantics the given updateSemantics to compare the actual VariableDocumentRecordValue's updateSemantics to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VariableDocumentRecordValue's updateSemantics is not equal to the given one.
   */
  public S hasUpdateSemantics(io.zeebe.protocol.VariableDocumentUpdateSemantic updateSemantics) {
    // check that actual VariableDocumentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting updateSemantics of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    io.zeebe.protocol.VariableDocumentUpdateSemantic actualUpdateSemantics = actual.getUpdateSemantics();
    if (!Objects.areEqual(actualUpdateSemantics, updateSemantics)) {
      failWithMessage(assertjErrorMessage, actual, updateSemantics, actualUpdateSemantics);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
