package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link MessageStartEventSubscriptionRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractMessageStartEventSubscriptionRecordValueAssert<S extends AbstractMessageStartEventSubscriptionRecordValueAssert<S, A>, A extends MessageStartEventSubscriptionRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMessageStartEventSubscriptionRecordValueAssert}</code> to make assertions on actual MessageStartEventSubscriptionRecordValue.
   * @param actual the MessageStartEventSubscriptionRecordValue we want to make assertions on.
   */
  protected AbstractMessageStartEventSubscriptionRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual MessageStartEventSubscriptionRecordValue's messageName is equal to the given one.
   * @param messageName the given messageName to compare the actual MessageStartEventSubscriptionRecordValue's messageName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageStartEventSubscriptionRecordValue's messageName is not equal to the given one.
   */
  public S hasMessageName(String messageName) {
    // check that actual MessageStartEventSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting messageName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualMessageName = actual.getMessageName();
    if (!Objects.areEqual(actualMessageName, messageName)) {
      failWithMessage(assertjErrorMessage, actual, messageName, actualMessageName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageStartEventSubscriptionRecordValue's startEventId is equal to the given one.
   * @param startEventId the given startEventId to compare the actual MessageStartEventSubscriptionRecordValue's startEventId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageStartEventSubscriptionRecordValue's startEventId is not equal to the given one.
   */
  public S hasStartEventId(String startEventId) {
    // check that actual MessageStartEventSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting startEventId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualStartEventId = actual.getStartEventId();
    if (!Objects.areEqual(actualStartEventId, startEventId)) {
      failWithMessage(assertjErrorMessage, actual, startEventId, actualStartEventId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageStartEventSubscriptionRecordValue's workflowKey is equal to the given one.
   * @param workflowKey the given workflowKey to compare the actual MessageStartEventSubscriptionRecordValue's workflowKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageStartEventSubscriptionRecordValue's workflowKey is not equal to the given one.
   */
  public S hasWorkflowKey(long workflowKey) {
    // check that actual MessageStartEventSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualWorkflowKey = actual.getWorkflowKey();
    if (actualWorkflowKey != workflowKey) {
      failWithMessage(assertjErrorMessage, actual, workflowKey, actualWorkflowKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
