package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link WorkflowInstanceRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractWorkflowInstanceRecordValueAssert<S extends AbstractWorkflowInstanceRecordValueAssert<S, A>, A extends WorkflowInstanceRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWorkflowInstanceRecordValueAssert}</code> to make assertions on actual WorkflowInstanceRecordValue.
   * @param actual the WorkflowInstanceRecordValue we want to make assertions on.
   */
  protected AbstractWorkflowInstanceRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's bpmnElementType is equal to the given one.
   * @param bpmnElementType the given bpmnElementType to compare the actual WorkflowInstanceRecordValue's bpmnElementType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's bpmnElementType is not equal to the given one.
   */
  public S hasBpmnElementType(io.zeebe.protocol.BpmnElementType bpmnElementType) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnElementType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    io.zeebe.protocol.BpmnElementType actualBpmnElementType = actual.getBpmnElementType();
    if (!Objects.areEqual(actualBpmnElementType, bpmnElementType)) {
      failWithMessage(assertjErrorMessage, actual, bpmnElementType, actualBpmnElementType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual WorkflowInstanceRecordValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's elementId is equal to the given one.
   * @param elementId the given elementId to compare the actual WorkflowInstanceRecordValue's elementId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's elementId is not equal to the given one.
   */
  public S hasElementId(String elementId) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualElementId = actual.getElementId();
    if (!Objects.areEqual(actualElementId, elementId)) {
      failWithMessage(assertjErrorMessage, actual, elementId, actualElementId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's flowScopeKey is equal to the given one.
   * @param flowScopeKey the given flowScopeKey to compare the actual WorkflowInstanceRecordValue's flowScopeKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's flowScopeKey is not equal to the given one.
   */
  public S hasFlowScopeKey(long flowScopeKey) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting flowScopeKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualFlowScopeKey = actual.getFlowScopeKey();
    if (actualFlowScopeKey != flowScopeKey) {
      failWithMessage(assertjErrorMessage, actual, flowScopeKey, actualFlowScopeKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's version is equal to the given one.
   * @param version the given version to compare the actual WorkflowInstanceRecordValue's version to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's version is not equal to the given one.
   */
  public S hasVersion(int version) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualVersion = actual.getVersion();
    if (actualVersion != version) {
      failWithMessage(assertjErrorMessage, actual, version, actualVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's workflowInstanceKey is equal to the given one.
   * @param workflowInstanceKey the given workflowInstanceKey to compare the actual WorkflowInstanceRecordValue's workflowInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's workflowInstanceKey is not equal to the given one.
   */
  public S hasWorkflowInstanceKey(long workflowInstanceKey) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualWorkflowInstanceKey = actual.getWorkflowInstanceKey();
    if (actualWorkflowInstanceKey != workflowInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, workflowInstanceKey, actualWorkflowInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's workflowKey is equal to the given one.
   * @param workflowKey the given workflowKey to compare the actual WorkflowInstanceRecordValue's workflowKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's workflowKey is not equal to the given one.
   */
  public S hasWorkflowKey(long workflowKey) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualWorkflowKey = actual.getWorkflowKey();
    if (actualWorkflowKey != workflowKey) {
      failWithMessage(assertjErrorMessage, actual, workflowKey, actualWorkflowKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
