package io.zeebe.exporter.record.value.deployment;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeployedWorkflow} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractDeployedWorkflowAssert<S extends AbstractDeployedWorkflowAssert<S, A>, A extends DeployedWorkflow> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeployedWorkflowAssert}</code> to make assertions on actual DeployedWorkflow.
   * @param actual the DeployedWorkflow we want to make assertions on.
   */
  protected AbstractDeployedWorkflowAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeployedWorkflow's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual DeployedWorkflow's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeployedWorkflow's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual DeployedWorkflow we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeployedWorkflow's resourceName is equal to the given one.
   * @param resourceName the given resourceName to compare the actual DeployedWorkflow's resourceName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeployedWorkflow's resourceName is not equal to the given one.
   */
  public S hasResourceName(String resourceName) {
    // check that actual DeployedWorkflow we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualResourceName = actual.getResourceName();
    if (!Objects.areEqual(actualResourceName, resourceName)) {
      failWithMessage(assertjErrorMessage, actual, resourceName, actualResourceName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeployedWorkflow's version is equal to the given one.
   * @param version the given version to compare the actual DeployedWorkflow's version to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeployedWorkflow's version is not equal to the given one.
   */
  public S hasVersion(int version) {
    // check that actual DeployedWorkflow we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualVersion = actual.getVersion();
    if (actualVersion != version) {
      failWithMessage(assertjErrorMessage, actual, version, actualVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeployedWorkflow's workflowKey is equal to the given one.
   * @param workflowKey the given workflowKey to compare the actual DeployedWorkflow's workflowKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeployedWorkflow's workflowKey is not equal to the given one.
   */
  public S hasWorkflowKey(long workflowKey) {
    // check that actual DeployedWorkflow we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualWorkflowKey = actual.getWorkflowKey();
    if (actualWorkflowKey != workflowKey) {
      failWithMessage(assertjErrorMessage, actual, workflowKey, actualWorkflowKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
