package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link WorkflowInstanceSubscriptionRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractWorkflowInstanceSubscriptionRecordValueAssert<S extends AbstractWorkflowInstanceSubscriptionRecordValueAssert<S, A>, A extends WorkflowInstanceSubscriptionRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWorkflowInstanceSubscriptionRecordValueAssert}</code> to make assertions on actual WorkflowInstanceSubscriptionRecordValue.
   * @param actual the WorkflowInstanceSubscriptionRecordValue we want to make assertions on.
   */
  protected AbstractWorkflowInstanceSubscriptionRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual WorkflowInstanceSubscriptionRecordValue's elementInstanceKey is equal to the given one.
   * @param elementInstanceKey the given elementInstanceKey to compare the actual WorkflowInstanceSubscriptionRecordValue's elementInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceSubscriptionRecordValue's elementInstanceKey is not equal to the given one.
   */
  public S hasElementInstanceKey(long elementInstanceKey) {
    // check that actual WorkflowInstanceSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualElementInstanceKey = actual.getElementInstanceKey();
    if (actualElementInstanceKey != elementInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, elementInstanceKey, actualElementInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceSubscriptionRecordValue's messageName is equal to the given one.
   * @param messageName the given messageName to compare the actual WorkflowInstanceSubscriptionRecordValue's messageName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceSubscriptionRecordValue's messageName is not equal to the given one.
   */
  public S hasMessageName(String messageName) {
    // check that actual WorkflowInstanceSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting messageName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualMessageName = actual.getMessageName();
    if (!Objects.areEqual(actualMessageName, messageName)) {
      failWithMessage(assertjErrorMessage, actual, messageName, actualMessageName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceSubscriptionRecordValue's workflowInstanceKey is equal to the given one.
   * @param workflowInstanceKey the given workflowInstanceKey to compare the actual WorkflowInstanceSubscriptionRecordValue's workflowInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceSubscriptionRecordValue's workflowInstanceKey is not equal to the given one.
   */
  public S hasWorkflowInstanceKey(long workflowInstanceKey) {
    // check that actual WorkflowInstanceSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualWorkflowInstanceKey = actual.getWorkflowInstanceKey();
    if (actualWorkflowInstanceKey != workflowInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, workflowInstanceKey, actualWorkflowInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
