package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TimerRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractTimerRecordValueAssert<S extends AbstractTimerRecordValueAssert<S, A>, A extends TimerRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTimerRecordValueAssert}</code> to make assertions on actual TimerRecordValue.
   * @param actual the TimerRecordValue we want to make assertions on.
   */
  protected AbstractTimerRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TimerRecordValue's dueDate is equal to the given one.
   * @param dueDate the given dueDate to compare the actual TimerRecordValue's dueDate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TimerRecordValue's dueDate is not equal to the given one.
   */
  public S hasDueDate(long dueDate) {
    // check that actual TimerRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dueDate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualDueDate = actual.getDueDate();
    if (actualDueDate != dueDate) {
      failWithMessage(assertjErrorMessage, actual, dueDate, actualDueDate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TimerRecordValue's elementInstanceKey is equal to the given one.
   * @param elementInstanceKey the given elementInstanceKey to compare the actual TimerRecordValue's elementInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TimerRecordValue's elementInstanceKey is not equal to the given one.
   */
  public S hasElementInstanceKey(long elementInstanceKey) {
    // check that actual TimerRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualElementInstanceKey = actual.getElementInstanceKey();
    if (actualElementInstanceKey != elementInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, elementInstanceKey, actualElementInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TimerRecordValue's handlerFlowNodeId is equal to the given one.
   * @param handlerFlowNodeId the given handlerFlowNodeId to compare the actual TimerRecordValue's handlerFlowNodeId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TimerRecordValue's handlerFlowNodeId is not equal to the given one.
   */
  public S hasHandlerFlowNodeId(String handlerFlowNodeId) {
    // check that actual TimerRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting handlerFlowNodeId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualHandlerFlowNodeId = actual.getHandlerFlowNodeId();
    if (!Objects.areEqual(actualHandlerFlowNodeId, handlerFlowNodeId)) {
      failWithMessage(assertjErrorMessage, actual, handlerFlowNodeId, actualHandlerFlowNodeId);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
