package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.internal.Iterables;

/**
 * Abstract base class for {@link DeploymentRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractDeploymentRecordValueAssert<S extends AbstractDeploymentRecordValueAssert<S, A>, A extends DeploymentRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentRecordValueAssert}</code> to make assertions on actual DeploymentRecordValue.
   * @param actual the DeploymentRecordValue we want to make assertions on.
   */
  protected AbstractDeploymentRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentRecordValue's deployedWorkflows contains the given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements.
   * @param deployedWorkflows the given elements that should be contained in actual DeploymentRecordValue's deployedWorkflows.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's deployedWorkflows does not contain all given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements.
   */
  public S hasDeployedWorkflows(io.zeebe.exporter.record.value.deployment.DeployedWorkflow... deployedWorkflows) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeployedWorkflow varargs is not null.
    if (deployedWorkflows == null) failWithMessage("Expecting deployedWorkflows parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getDeployedWorkflows(), deployedWorkflows);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue's deployedWorkflows contains the given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements in Collection.
   * @param deployedWorkflows the given elements that should be contained in actual DeploymentRecordValue's deployedWorkflows.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's deployedWorkflows does not contain all given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements.
   */
  public S hasDeployedWorkflows(java.util.Collection<? extends io.zeebe.exporter.record.value.deployment.DeployedWorkflow> deployedWorkflows) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeployedWorkflow collection is not null.
    if (deployedWorkflows == null) {
      failWithMessage("Expecting deployedWorkflows parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getDeployedWorkflows(), deployedWorkflows.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue's deployedWorkflows contains <b>only</b> the given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements and nothing else in whatever order.
   * @param deployedWorkflows the given elements that should be contained in actual DeploymentRecordValue's deployedWorkflows.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's deployedWorkflows does not contain all given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements.
   */
  public S hasOnlyDeployedWorkflows(io.zeebe.exporter.record.value.deployment.DeployedWorkflow... deployedWorkflows) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeployedWorkflow varargs is not null.
    if (deployedWorkflows == null) failWithMessage("Expecting deployedWorkflows parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getDeployedWorkflows(), deployedWorkflows);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue's deployedWorkflows contains <b>only</b> the given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements in Collection and nothing else in whatever order.
   * @param deployedWorkflows the given elements that should be contained in actual DeploymentRecordValue's deployedWorkflows.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's deployedWorkflows does not contain all given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements.
   */
  public S hasOnlyDeployedWorkflows(java.util.Collection<? extends io.zeebe.exporter.record.value.deployment.DeployedWorkflow> deployedWorkflows) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeployedWorkflow collection is not null.
    if (deployedWorkflows == null) {
      failWithMessage("Expecting deployedWorkflows parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getDeployedWorkflows(), deployedWorkflows.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue's deployedWorkflows does not contain the given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements.
   *
   * @param deployedWorkflows the given elements that should not be in actual DeploymentRecordValue's deployedWorkflows.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's deployedWorkflows contains any given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements.
   */
  public S doesNotHaveDeployedWorkflows(io.zeebe.exporter.record.value.deployment.DeployedWorkflow... deployedWorkflows) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeployedWorkflow varargs is not null.
    if (deployedWorkflows == null) failWithMessage("Expecting deployedWorkflows parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getDeployedWorkflows(), deployedWorkflows);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue's deployedWorkflows does not contain the given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements in Collection.
   *
   * @param deployedWorkflows the given elements that should not be in actual DeploymentRecordValue's deployedWorkflows.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's deployedWorkflows contains any given io.zeebe.exporter.record.value.deployment.DeployedWorkflow elements.
   */
  public S doesNotHaveDeployedWorkflows(java.util.Collection<? extends io.zeebe.exporter.record.value.deployment.DeployedWorkflow> deployedWorkflows) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeployedWorkflow collection is not null.
    if (deployedWorkflows == null) {
      failWithMessage("Expecting deployedWorkflows parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getDeployedWorkflows(), deployedWorkflows.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue has no deployedWorkflows.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's deployedWorkflows is not empty.
   */
  public S hasNoDeployedWorkflows() {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have deployedWorkflows but had :\n  <%s>";

    // check
    if (actual.getDeployedWorkflows().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getDeployedWorkflows());
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual DeploymentRecordValue's resources contains the given io.zeebe.exporter.record.value.deployment.DeploymentResource elements.
   * @param resources the given elements that should be contained in actual DeploymentRecordValue's resources.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's resources does not contain all given io.zeebe.exporter.record.value.deployment.DeploymentResource elements.
   */
  public S hasResources(io.zeebe.exporter.record.value.deployment.DeploymentResource... resources) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeploymentResource varargs is not null.
    if (resources == null) failWithMessage("Expecting resources parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getResources(), resources);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue's resources contains the given io.zeebe.exporter.record.value.deployment.DeploymentResource elements in Collection.
   * @param resources the given elements that should be contained in actual DeploymentRecordValue's resources.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's resources does not contain all given io.zeebe.exporter.record.value.deployment.DeploymentResource elements.
   */
  public S hasResources(java.util.Collection<? extends io.zeebe.exporter.record.value.deployment.DeploymentResource> resources) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeploymentResource collection is not null.
    if (resources == null) {
      failWithMessage("Expecting resources parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getResources(), resources.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue's resources contains <b>only</b> the given io.zeebe.exporter.record.value.deployment.DeploymentResource elements and nothing else in whatever order.
   * @param resources the given elements that should be contained in actual DeploymentRecordValue's resources.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's resources does not contain all given io.zeebe.exporter.record.value.deployment.DeploymentResource elements.
   */
  public S hasOnlyResources(io.zeebe.exporter.record.value.deployment.DeploymentResource... resources) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeploymentResource varargs is not null.
    if (resources == null) failWithMessage("Expecting resources parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getResources(), resources);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue's resources contains <b>only</b> the given io.zeebe.exporter.record.value.deployment.DeploymentResource elements in Collection and nothing else in whatever order.
   * @param resources the given elements that should be contained in actual DeploymentRecordValue's resources.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's resources does not contain all given io.zeebe.exporter.record.value.deployment.DeploymentResource elements.
   */
  public S hasOnlyResources(java.util.Collection<? extends io.zeebe.exporter.record.value.deployment.DeploymentResource> resources) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeploymentResource collection is not null.
    if (resources == null) {
      failWithMessage("Expecting resources parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getResources(), resources.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue's resources does not contain the given io.zeebe.exporter.record.value.deployment.DeploymentResource elements.
   *
   * @param resources the given elements that should not be in actual DeploymentRecordValue's resources.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's resources contains any given io.zeebe.exporter.record.value.deployment.DeploymentResource elements.
   */
  public S doesNotHaveResources(io.zeebe.exporter.record.value.deployment.DeploymentResource... resources) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeploymentResource varargs is not null.
    if (resources == null) failWithMessage("Expecting resources parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getResources(), resources);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue's resources does not contain the given io.zeebe.exporter.record.value.deployment.DeploymentResource elements in Collection.
   *
   * @param resources the given elements that should not be in actual DeploymentRecordValue's resources.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's resources contains any given io.zeebe.exporter.record.value.deployment.DeploymentResource elements.
   */
  public S doesNotHaveResources(java.util.Collection<? extends io.zeebe.exporter.record.value.deployment.DeploymentResource> resources) {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.deployment.DeploymentResource collection is not null.
    if (resources == null) {
      failWithMessage("Expecting resources parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getResources(), resources.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentRecordValue has no resources.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentRecordValue's resources is not empty.
   */
  public S hasNoResources() {
    // check that actual DeploymentRecordValue we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resources but had :\n  <%s>";

    // check
    if (actual.getResources().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getResources());
    }

    // return the current assertion for method chaining
    return myself;
  }


}
