package io.zeebe.exporter.record;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RecordValueWithPayload} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractRecordValueWithPayloadAssert<S extends AbstractRecordValueWithPayloadAssert<S, A>, A extends RecordValueWithPayload> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRecordValueWithPayloadAssert}</code> to make assertions on actual RecordValueWithPayload.
   * @param actual the RecordValueWithPayload we want to make assertions on.
   */
  protected AbstractRecordValueWithPayloadAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RecordValueWithPayload's payload is equal to the given one.
   * @param payload the given payload to compare the actual RecordValueWithPayload's payload to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecordValueWithPayload's payload is not equal to the given one.
   */
  public S hasPayload(String payload) {
    // check that actual RecordValueWithPayload we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting payload of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualPayload = actual.getPayload();
    if (!Objects.areEqual(actualPayload, payload)) {
      failWithMessage(assertjErrorMessage, actual, payload, actualPayload);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RecordValueWithPayload's payloadAsMap is equal to the given one.
   * @param payloadAsMap the given payloadAsMap to compare the actual RecordValueWithPayload's payloadAsMap to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecordValueWithPayload's payloadAsMap is not equal to the given one.
   */
  public S hasPayloadAsMap(java.util.Map payloadAsMap) {
    // check that actual RecordValueWithPayload we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting payloadAsMap of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.util.Map actualPayloadAsMap = actual.getPayloadAsMap();
    if (!Objects.areEqual(actualPayloadAsMap, payloadAsMap)) {
      failWithMessage(assertjErrorMessage, actual, payloadAsMap, actualPayloadAsMap);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
