package io.zeebe.exporter.record;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Record} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractRecordAssert<S extends AbstractRecordAssert<S, A>, A extends Record> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRecordAssert}</code> to make assertions on actual Record.
   * @param actual the Record we want to make assertions on.
   */
  protected AbstractRecordAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Record's key is equal to the given one.
   * @param key the given key to compare the actual Record's key to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Record's key is not equal to the given one.
   */
  public S hasKey(long key) {
    // check that actual Record we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting key of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualKey = actual.getKey();
    if (actualKey != key) {
      failWithMessage(assertjErrorMessage, actual, key, actualKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Record's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual Record's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Record's metadata is not equal to the given one.
   */
  public S hasMetadata(RecordMetadata metadata) {
    // check that actual Record we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    RecordMetadata actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Record's position is equal to the given one.
   * @param position the given position to compare the actual Record's position to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Record's position is not equal to the given one.
   */
  public S hasPosition(long position) {
    // check that actual Record we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting position of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualPosition = actual.getPosition();
    if (actualPosition != position) {
      failWithMessage(assertjErrorMessage, actual, position, actualPosition);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Record's producerId is equal to the given one.
   * @param producerId the given producerId to compare the actual Record's producerId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Record's producerId is not equal to the given one.
   */
  public S hasProducerId(int producerId) {
    // check that actual Record we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting producerId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualProducerId = actual.getProducerId();
    if (actualProducerId != producerId) {
      failWithMessage(assertjErrorMessage, actual, producerId, actualProducerId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Record's raftTerm is equal to the given one.
   * @param raftTerm the given raftTerm to compare the actual Record's raftTerm to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Record's raftTerm is not equal to the given one.
   */
  public S hasRaftTerm(int raftTerm) {
    // check that actual Record we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting raftTerm of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualRaftTerm = actual.getRaftTerm();
    if (actualRaftTerm != raftTerm) {
      failWithMessage(assertjErrorMessage, actual, raftTerm, actualRaftTerm);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Record's sourceRecordPosition is equal to the given one.
   * @param sourceRecordPosition the given sourceRecordPosition to compare the actual Record's sourceRecordPosition to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Record's sourceRecordPosition is not equal to the given one.
   */
  public S hasSourceRecordPosition(long sourceRecordPosition) {
    // check that actual Record we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting sourceRecordPosition of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualSourceRecordPosition = actual.getSourceRecordPosition();
    if (actualSourceRecordPosition != sourceRecordPosition) {
      failWithMessage(assertjErrorMessage, actual, sourceRecordPosition, actualSourceRecordPosition);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Record's timestamp is equal to the given one.
   * @param timestamp the given timestamp to compare the actual Record's timestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Record's timestamp is not equal to the given one.
   */
  public S hasTimestamp(java.time.Instant timestamp) {
    // check that actual Record we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting timestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.time.Instant actualTimestamp = actual.getTimestamp();
    if (!Objects.areEqual(actualTimestamp, timestamp)) {
      failWithMessage(assertjErrorMessage, actual, timestamp, actualTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Record's value is equal to the given one.
   * @param value the given value to compare the actual Record's value to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Record's value is not equal to the given one.
   */
  public S hasValue(RecordValue value) {
    // check that actual Record we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    RecordValue actualValue = actual.getValue();
    if (!Objects.areEqual(actualValue, value)) {
      failWithMessage(assertjErrorMessage, actual, value, actualValue);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
