package io.zeebe.exporter.record.value.job;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Headers} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractHeadersAssert<S extends AbstractHeadersAssert<S, A>, A extends Headers> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHeadersAssert}</code> to make assertions on actual Headers.
   * @param actual the Headers we want to make assertions on.
   */
  protected AbstractHeadersAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Headers's activityId is equal to the given one.
   * @param activityId the given activityId to compare the actual Headers's activityId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Headers's activityId is not equal to the given one.
   */
  public S hasActivityId(String activityId) {
    // check that actual Headers we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting activityId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualActivityId = actual.getActivityId();
    if (!Objects.areEqual(actualActivityId, activityId)) {
      failWithMessage(assertjErrorMessage, actual, activityId, actualActivityId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Headers's activityInstanceKey is equal to the given one.
   * @param activityInstanceKey the given activityInstanceKey to compare the actual Headers's activityInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Headers's activityInstanceKey is not equal to the given one.
   */
  public S hasActivityInstanceKey(long activityInstanceKey) {
    // check that actual Headers we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting activityInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualActivityInstanceKey = actual.getActivityInstanceKey();
    if (actualActivityInstanceKey != activityInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, activityInstanceKey, actualActivityInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Headers's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual Headers's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Headers's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual Headers we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Headers's workflowDefinitionVersion is equal to the given one.
   * @param workflowDefinitionVersion the given workflowDefinitionVersion to compare the actual Headers's workflowDefinitionVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Headers's workflowDefinitionVersion is not equal to the given one.
   */
  public S hasWorkflowDefinitionVersion(int workflowDefinitionVersion) {
    // check that actual Headers we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowDefinitionVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualWorkflowDefinitionVersion = actual.getWorkflowDefinitionVersion();
    if (actualWorkflowDefinitionVersion != workflowDefinitionVersion) {
      failWithMessage(assertjErrorMessage, actual, workflowDefinitionVersion, actualWorkflowDefinitionVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Headers's workflowInstanceKey is equal to the given one.
   * @param workflowInstanceKey the given workflowInstanceKey to compare the actual Headers's workflowInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Headers's workflowInstanceKey is not equal to the given one.
   */
  public S hasWorkflowInstanceKey(long workflowInstanceKey) {
    // check that actual Headers we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualWorkflowInstanceKey = actual.getWorkflowInstanceKey();
    if (actualWorkflowInstanceKey != workflowInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, workflowInstanceKey, actualWorkflowInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Headers's workflowKey is equal to the given one.
   * @param workflowKey the given workflowKey to compare the actual Headers's workflowKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Headers's workflowKey is not equal to the given one.
   */
  public S hasWorkflowKey(long workflowKey) {
    // check that actual Headers we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualWorkflowKey = actual.getWorkflowKey();
    if (actualWorkflowKey != workflowKey) {
      failWithMessage(assertjErrorMessage, actual, workflowKey, actualWorkflowKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
