package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link WorkflowInstanceRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractWorkflowInstanceRecordValueAssert<S extends AbstractWorkflowInstanceRecordValueAssert<S, A>, A extends WorkflowInstanceRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWorkflowInstanceRecordValueAssert}</code> to make assertions on actual WorkflowInstanceRecordValue.
   * @param actual the WorkflowInstanceRecordValue we want to make assertions on.
   */
  protected AbstractWorkflowInstanceRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's activityId is equal to the given one.
   * @param activityId the given activityId to compare the actual WorkflowInstanceRecordValue's activityId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's activityId is not equal to the given one.
   */
  public S hasActivityId(String activityId) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting activityId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualActivityId = actual.getActivityId();
    if (!Objects.areEqual(actualActivityId, activityId)) {
      failWithMessage(assertjErrorMessage, actual, activityId, actualActivityId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual WorkflowInstanceRecordValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's scopeInstanceKey is equal to the given one.
   * @param scopeInstanceKey the given scopeInstanceKey to compare the actual WorkflowInstanceRecordValue's scopeInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's scopeInstanceKey is not equal to the given one.
   */
  public S hasScopeInstanceKey(long scopeInstanceKey) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting scopeInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualScopeInstanceKey = actual.getScopeInstanceKey();
    if (actualScopeInstanceKey != scopeInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, scopeInstanceKey, actualScopeInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's version is equal to the given one.
   * @param version the given version to compare the actual WorkflowInstanceRecordValue's version to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's version is not equal to the given one.
   */
  public S hasVersion(int version) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualVersion = actual.getVersion();
    if (actualVersion != version) {
      failWithMessage(assertjErrorMessage, actual, version, actualVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's workflowInstanceKey is equal to the given one.
   * @param workflowInstanceKey the given workflowInstanceKey to compare the actual WorkflowInstanceRecordValue's workflowInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's workflowInstanceKey is not equal to the given one.
   */
  public S hasWorkflowInstanceKey(long workflowInstanceKey) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualWorkflowInstanceKey = actual.getWorkflowInstanceKey();
    if (actualWorkflowInstanceKey != workflowInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, workflowInstanceKey, actualWorkflowInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual WorkflowInstanceRecordValue's workflowKey is equal to the given one.
   * @param workflowKey the given workflowKey to compare the actual WorkflowInstanceRecordValue's workflowKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WorkflowInstanceRecordValue's workflowKey is not equal to the given one.
   */
  public S hasWorkflowKey(long workflowKey) {
    // check that actual WorkflowInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualWorkflowKey = actual.getWorkflowKey();
    if (actualWorkflowKey != workflowKey) {
      failWithMessage(assertjErrorMessage, actual, workflowKey, actualWorkflowKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
