package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.internal.Iterables;

/**
 * Abstract base class for {@link RaftRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractRaftRecordValueAssert<S extends AbstractRaftRecordValueAssert<S, A>, A extends RaftRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRaftRecordValueAssert}</code> to make assertions on actual RaftRecordValue.
   * @param actual the RaftRecordValue we want to make assertions on.
   */
  protected AbstractRaftRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RaftRecordValue's members contains the given io.zeebe.exporter.record.value.raft.RaftMember elements.
   * @param members the given elements that should be contained in actual RaftRecordValue's members.
   * @return this assertion object.
   * @throws AssertionError if the actual RaftRecordValue's members does not contain all given io.zeebe.exporter.record.value.raft.RaftMember elements.
   */
  public S hasMembers(io.zeebe.exporter.record.value.raft.RaftMember... members) {
    // check that actual RaftRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.raft.RaftMember varargs is not null.
    if (members == null) failWithMessage("Expecting members parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getMembers(), members);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RaftRecordValue's members contains the given io.zeebe.exporter.record.value.raft.RaftMember elements in Collection.
   * @param members the given elements that should be contained in actual RaftRecordValue's members.
   * @return this assertion object.
   * @throws AssertionError if the actual RaftRecordValue's members does not contain all given io.zeebe.exporter.record.value.raft.RaftMember elements.
   */
  public S hasMembers(java.util.Collection<? extends io.zeebe.exporter.record.value.raft.RaftMember> members) {
    // check that actual RaftRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.raft.RaftMember collection is not null.
    if (members == null) {
      failWithMessage("Expecting members parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getMembers(), members.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RaftRecordValue's members contains <b>only</b> the given io.zeebe.exporter.record.value.raft.RaftMember elements and nothing else in whatever order.
   * @param members the given elements that should be contained in actual RaftRecordValue's members.
   * @return this assertion object.
   * @throws AssertionError if the actual RaftRecordValue's members does not contain all given io.zeebe.exporter.record.value.raft.RaftMember elements.
   */
  public S hasOnlyMembers(io.zeebe.exporter.record.value.raft.RaftMember... members) {
    // check that actual RaftRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.raft.RaftMember varargs is not null.
    if (members == null) failWithMessage("Expecting members parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getMembers(), members);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RaftRecordValue's members contains <b>only</b> the given io.zeebe.exporter.record.value.raft.RaftMember elements in Collection and nothing else in whatever order.
   * @param members the given elements that should be contained in actual RaftRecordValue's members.
   * @return this assertion object.
   * @throws AssertionError if the actual RaftRecordValue's members does not contain all given io.zeebe.exporter.record.value.raft.RaftMember elements.
   */
  public S hasOnlyMembers(java.util.Collection<? extends io.zeebe.exporter.record.value.raft.RaftMember> members) {
    // check that actual RaftRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.raft.RaftMember collection is not null.
    if (members == null) {
      failWithMessage("Expecting members parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getMembers(), members.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RaftRecordValue's members does not contain the given io.zeebe.exporter.record.value.raft.RaftMember elements.
   *
   * @param members the given elements that should not be in actual RaftRecordValue's members.
   * @return this assertion object.
   * @throws AssertionError if the actual RaftRecordValue's members contains any given io.zeebe.exporter.record.value.raft.RaftMember elements.
   */
  public S doesNotHaveMembers(io.zeebe.exporter.record.value.raft.RaftMember... members) {
    // check that actual RaftRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.raft.RaftMember varargs is not null.
    if (members == null) failWithMessage("Expecting members parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getMembers(), members);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RaftRecordValue's members does not contain the given io.zeebe.exporter.record.value.raft.RaftMember elements in Collection.
   *
   * @param members the given elements that should not be in actual RaftRecordValue's members.
   * @return this assertion object.
   * @throws AssertionError if the actual RaftRecordValue's members contains any given io.zeebe.exporter.record.value.raft.RaftMember elements.
   */
  public S doesNotHaveMembers(java.util.Collection<? extends io.zeebe.exporter.record.value.raft.RaftMember> members) {
    // check that actual RaftRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given io.zeebe.exporter.record.value.raft.RaftMember collection is not null.
    if (members == null) {
      failWithMessage("Expecting members parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getMembers(), members.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RaftRecordValue has no members.
   * @return this assertion object.
   * @throws AssertionError if the actual RaftRecordValue's members is not empty.
   */
  public S hasNoMembers() {
    // check that actual RaftRecordValue we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have members but had :\n  <%s>";

    // check
    if (actual.getMembers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getMembers());
    }

    // return the current assertion for method chaining
    return myself;
  }


}
