package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link MessageSubscriptionRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractMessageSubscriptionRecordValueAssert<S extends AbstractMessageSubscriptionRecordValueAssert<S, A>, A extends MessageSubscriptionRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMessageSubscriptionRecordValueAssert}</code> to make assertions on actual MessageSubscriptionRecordValue.
   * @param actual the MessageSubscriptionRecordValue we want to make assertions on.
   */
  protected AbstractMessageSubscriptionRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue's activityInstanceKey is equal to the given one.
   * @param activityInstanceKey the given activityInstanceKey to compare the actual MessageSubscriptionRecordValue's activityInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue's activityInstanceKey is not equal to the given one.
   */
  public S hasActivityInstanceKey(long activityInstanceKey) {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting activityInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualActivityInstanceKey = actual.getActivityInstanceKey();
    if (actualActivityInstanceKey != activityInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, activityInstanceKey, actualActivityInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue's correlationKey is equal to the given one.
   * @param correlationKey the given correlationKey to compare the actual MessageSubscriptionRecordValue's correlationKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue's correlationKey is not equal to the given one.
   */
  public S hasCorrelationKey(String correlationKey) {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting correlationKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualCorrelationKey = actual.getCorrelationKey();
    if (!Objects.areEqual(actualCorrelationKey, correlationKey)) {
      failWithMessage(assertjErrorMessage, actual, correlationKey, actualCorrelationKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue's messageName is equal to the given one.
   * @param messageName the given messageName to compare the actual MessageSubscriptionRecordValue's messageName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue's messageName is not equal to the given one.
   */
  public S hasMessageName(String messageName) {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting messageName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualMessageName = actual.getMessageName();
    if (!Objects.areEqual(actualMessageName, messageName)) {
      failWithMessage(assertjErrorMessage, actual, messageName, actualMessageName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue's workflowInstanceKey is equal to the given one.
   * @param workflowInstanceKey the given workflowInstanceKey to compare the actual MessageSubscriptionRecordValue's workflowInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue's workflowInstanceKey is not equal to the given one.
   */
  public S hasWorkflowInstanceKey(long workflowInstanceKey) {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualWorkflowInstanceKey = actual.getWorkflowInstanceKey();
    if (actualWorkflowInstanceKey != workflowInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, workflowInstanceKey, actualWorkflowInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue's workflowInstancePartitionId is equal to the given one.
   * @param workflowInstancePartitionId the given workflowInstancePartitionId to compare the actual MessageSubscriptionRecordValue's workflowInstancePartitionId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue's workflowInstancePartitionId is not equal to the given one.
   */
  public S hasWorkflowInstancePartitionId(int workflowInstancePartitionId) {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowInstancePartitionId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualWorkflowInstancePartitionId = actual.getWorkflowInstancePartitionId();
    if (actualWorkflowInstancePartitionId != workflowInstancePartitionId) {
      failWithMessage(assertjErrorMessage, actual, workflowInstancePartitionId, actualWorkflowInstancePartitionId);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
