package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link JobRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractJobRecordValueAssert<S extends AbstractJobRecordValueAssert<S, A>, A extends JobRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJobRecordValueAssert}</code> to make assertions on actual JobRecordValue.
   * @param actual the JobRecordValue we want to make assertions on.
   */
  protected AbstractJobRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual JobRecordValue's customHeaders is equal to the given one.
   * @param customHeaders the given customHeaders to compare the actual JobRecordValue's customHeaders to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's customHeaders is not equal to the given one.
   */
  public S hasCustomHeaders(java.util.Map customHeaders) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting customHeaders of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.util.Map actualCustomHeaders = actual.getCustomHeaders();
    if (!Objects.areEqual(actualCustomHeaders, customHeaders)) {
      failWithMessage(assertjErrorMessage, actual, customHeaders, actualCustomHeaders);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's deadline is equal to the given one.
   * @param deadline the given deadline to compare the actual JobRecordValue's deadline to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's deadline is not equal to the given one.
   */
  public S hasDeadline(java.time.Instant deadline) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting deadline of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.time.Instant actualDeadline = actual.getDeadline();
    if (!Objects.areEqual(actualDeadline, deadline)) {
      failWithMessage(assertjErrorMessage, actual, deadline, actualDeadline);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's headers is equal to the given one.
   * @param headers the given headers to compare the actual JobRecordValue's headers to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's headers is not equal to the given one.
   */
  public S hasHeaders(io.zeebe.exporter.record.value.job.Headers headers) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting headers of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    io.zeebe.exporter.record.value.job.Headers actualHeaders = actual.getHeaders();
    if (!Objects.areEqual(actualHeaders, headers)) {
      failWithMessage(assertjErrorMessage, actual, headers, actualHeaders);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's retries is equal to the given one.
   * @param retries the given retries to compare the actual JobRecordValue's retries to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's retries is not equal to the given one.
   */
  public S hasRetries(int retries) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting retries of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualRetries = actual.getRetries();
    if (actualRetries != retries) {
      failWithMessage(assertjErrorMessage, actual, retries, actualRetries);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's type is equal to the given one.
   * @param type the given type to compare the actual JobRecordValue's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's worker is equal to the given one.
   * @param worker the given worker to compare the actual JobRecordValue's worker to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's worker is not equal to the given one.
   */
  public S hasWorker(String worker) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting worker of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualWorker = actual.getWorker();
    if (!Objects.areEqual(actualWorker, worker)) {
      failWithMessage(assertjErrorMessage, actual, worker, actualWorker);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
