package io.zeebe.exporter.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IncidentRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractIncidentRecordValueAssert<S extends AbstractIncidentRecordValueAssert<S, A>, A extends IncidentRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIncidentRecordValueAssert}</code> to make assertions on actual IncidentRecordValue.
   * @param actual the IncidentRecordValue we want to make assertions on.
   */
  protected AbstractIncidentRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IncidentRecordValue's activityId is equal to the given one.
   * @param activityId the given activityId to compare the actual IncidentRecordValue's activityId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's activityId is not equal to the given one.
   */
  public S hasActivityId(String activityId) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting activityId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualActivityId = actual.getActivityId();
    if (!Objects.areEqual(actualActivityId, activityId)) {
      failWithMessage(assertjErrorMessage, actual, activityId, actualActivityId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's activityInstanceKey is equal to the given one.
   * @param activityInstanceKey the given activityInstanceKey to compare the actual IncidentRecordValue's activityInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's activityInstanceKey is not equal to the given one.
   */
  public S hasActivityInstanceKey(long activityInstanceKey) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting activityInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualActivityInstanceKey = actual.getActivityInstanceKey();
    if (actualActivityInstanceKey != activityInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, activityInstanceKey, actualActivityInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual IncidentRecordValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's errorMessage is equal to the given one.
   * @param errorMessage the given errorMessage to compare the actual IncidentRecordValue's errorMessage to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's errorMessage is not equal to the given one.
   */
  public S hasErrorMessage(String errorMessage) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting errorMessage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualErrorMessage = actual.getErrorMessage();
    if (!Objects.areEqual(actualErrorMessage, errorMessage)) {
      failWithMessage(assertjErrorMessage, actual, errorMessage, actualErrorMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's errorType is equal to the given one.
   * @param errorType the given errorType to compare the actual IncidentRecordValue's errorType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's errorType is not equal to the given one.
   */
  public S hasErrorType(String errorType) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting errorType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualErrorType = actual.getErrorType();
    if (!Objects.areEqual(actualErrorType, errorType)) {
      failWithMessage(assertjErrorMessage, actual, errorType, actualErrorType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's jobKey is equal to the given one.
   * @param jobKey the given jobKey to compare the actual IncidentRecordValue's jobKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's jobKey is not equal to the given one.
   */
  public S hasJobKey(long jobKey) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting jobKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualJobKey = actual.getJobKey();
    if (actualJobKey != jobKey) {
      failWithMessage(assertjErrorMessage, actual, jobKey, actualJobKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's workflowInstanceKey is equal to the given one.
   * @param workflowInstanceKey the given workflowInstanceKey to compare the actual IncidentRecordValue's workflowInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's workflowInstanceKey is not equal to the given one.
   */
  public S hasWorkflowInstanceKey(long workflowInstanceKey) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting workflowInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualWorkflowInstanceKey = actual.getWorkflowInstanceKey();
    if (actualWorkflowInstanceKey != workflowInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, workflowInstanceKey, actualWorkflowInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
