/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.impl;

import io.wcm.caconfig.editor.impl.DropdownOptionProviderService;
import io.wcm.caconfig.editor.impl.EditorConfig;
import io.wcm.caconfig.editor.impl.JsonMapper;
import io.wcm.caconfig.editor.impl.PathBrowserRootPathProviderService;
import io.wcm.caconfig.editor.impl.TagBrowserRootPathProviderService;
import io.wcm.caconfig.editor.impl.data.configdata.ConfigCollectionItem;
import io.wcm.caconfig.editor.impl.data.configdata.ConfigItem;
import io.wcm.caconfig.editor.impl.data.configdata.PropertyItem;
import io.wcm.caconfig.editor.impl.data.configdata.PropertyItemMetadata;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.caconfig.management.ConfigurationCollectionData;
import org.apache.sling.caconfig.management.ConfigurationData;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.management.ValueInfo;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationPersistenceStrategyMultiplexer;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceException;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"/apps/wcm-io/caconfig/editor/components/page/editor"}, selectors={"configData"}, extensions={"json"}, methods={"GET"})
public class ConfigDataServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String SELECTOR = "configData";
    private static final Pattern JSON_STRING_ARRAY_PATTERN = Pattern.compile("^\\[.*\\]$");
    private static final Pattern JSON_STRING_OBJECT_PATTERN = Pattern.compile("^\\{.*\\}$");
    @Reference
    private ConfigurationManager configManager;
    @Reference
    private ConfigurationPersistenceStrategyMultiplexer configurationPersistenceStrategy;
    @Reference
    private EditorConfig editorConfig;
    @Reference
    private DropdownOptionProviderService dropdownOptionProviderService;
    @Reference
    private PathBrowserRootPathProviderService pathBrowserRootPathProviderService;
    @Reference
    private TagBrowserRootPathProviderService tagBrowserRootPathProviderService;
    private static Logger log = LoggerFactory.getLogger(ConfigDataServlet.class);

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.editorConfig.isEnabled()) {
            response.sendError(403);
            return;
        }
        String configName = request.getParameter("configName");
        if (StringUtils.isBlank((CharSequence)configName)) {
            response.sendError(404);
            return;
        }
        boolean collection = BooleanUtils.toBoolean((String)request.getParameter("collection"));
        try {
            Object result = this.getConfiguration(request.getResource(), configName, collection);
            if (result == null) {
                response.sendError(404);
            } else {
                response.setContentType("application/json;charset=" + StandardCharsets.UTF_8.name());
                response.getWriter().write(JsonMapper.OBJECT_MAPPER.writeValueAsString(result));
            }
        }
        catch (Exception ex) {
            log.error("Error getting configuration for " + configName + (collection ? "[col]" : ""), (Throwable)ex);
            response.sendError(500, ex.getMessage());
        }
    }

    private Object getConfiguration(@NotNull Resource contextResource, String configName, boolean collection) {
        Object result;
        if (collection) {
            ConfigurationData newItem = this.configManager.newCollectionItem(contextResource, configName);
            if (newItem == null) {
                throw new ConfigurationPersistenceException("Invalid configuration name: " + configName);
            }
            result = this.fromConfigCollection(contextResource, this.configManager.getConfigurationCollection(contextResource, configName), newItem, configName);
        } else {
            ConfigurationData configData = this.configManager.getConfiguration(contextResource, configName);
            result = configData != null ? this.fromConfig(contextResource, configData, configData.isInherited(), configName) : null;
        }
        return result;
    }

    private ConfigCollectionItem fromConfigCollection(@NotNull Resource contextResource, ConfigurationCollectionData configCollection, ConfigurationData newItem, String fullConfigName) {
        ConfigCollectionItem result = new ConfigCollectionItem();
        result.setConfigName(configCollection.getConfigName());
        if (!configCollection.getProperties().isEmpty()) {
            TreeMap<String, Object> properties = new TreeMap<String, Object>();
            for (Map.Entry entry : configCollection.getProperties().entrySet()) {
                properties.put((String)entry.getKey(), entry.getValue());
            }
            result.setProperties(properties);
        }
        ArrayList<ConfigItem> items = new ArrayList<ConfigItem>();
        for (ConfigurationData configurationData : configCollection.getItems()) {
            items.add(this.fromConfig(contextResource, configurationData, configurationData.isInherited(), fullConfigName));
        }
        result.setItems(items);
        result.setNewItem(this.fromConfig(contextResource, newItem, null, fullConfigName));
        return result;
    }

    private ConfigItem fromConfig(@NotNull Resource contextResource, ConfigurationData config, Boolean inherited, String fullConfigName) {
        ConfigItem result = new ConfigItem();
        result.setConfigName(config.getConfigName());
        result.setCollectionItemName(config.getCollectionItemName());
        result.setOverridden(config.isOverridden());
        result.setInherited(inherited);
        ArrayList<PropertyItem> props = new ArrayList<PropertyItem>();
        for (String propertyName : config.getPropertyNames()) {
            PropertyItemMetadata metadata;
            ValueInfo item = config.getValueInfo(propertyName);
            if (item == null) continue;
            PropertyMetadata itemMetadata = item.getPropertyMetadata();
            PropertyItem prop = new PropertyItem();
            prop.setName(item.getName());
            if (itemMetadata != null && itemMetadata.isNestedConfiguration()) {
                metadata = new PropertyItemMetadata();
                metadata.setLabel(itemMetadata.getLabel());
                metadata.setDescription(itemMetadata.getDescription());
                metadata.setProperties(this.toJsonWithValueConversion(itemMetadata.getProperties(), contextResource));
                prop.setMetadata(metadata);
                if (itemMetadata.getType().isArray()) {
                    ConfigurationData[] configDatas = (ConfigurationData[])item.getValue();
                    if (configDatas != null) {
                        ConfigCollectionItem nestedConfigCollection = new ConfigCollectionItem();
                        StringBuilder collectionConfigName = new StringBuilder();
                        if (config.getCollectionItemName() != null) {
                            collectionConfigName.append(this.configurationPersistenceStrategy.getCollectionItemConfigName(fullConfigName + "/" + config.getCollectionItemName(), config.getResourcePath()));
                        } else {
                            collectionConfigName.append(this.configurationPersistenceStrategy.getConfigName(fullConfigName, config.getResourcePath()));
                        }
                        collectionConfigName.append("/").append(itemMetadata.getConfigurationMetadata().getName());
                        nestedConfigCollection.setConfigName(collectionConfigName.toString());
                        ArrayList<ConfigItem> items = new ArrayList<ConfigItem>();
                        for (ConfigurationData configData : configDatas) {
                            items.add(this.fromConfig(contextResource, configData, false, collectionConfigName.toString()));
                        }
                        nestedConfigCollection.setItems(items);
                        prop.setNestedConfigCollection(nestedConfigCollection);
                    }
                } else {
                    ConfigurationData configData = (ConfigurationData)item.getValue();
                    if (configData != null) {
                        prop.setNestedConfig(this.fromConfig(contextResource, configData, null, fullConfigName + "/" + itemMetadata.getConfigurationMetadata().getName()));
                    }
                }
            } else {
                prop.setValue(item.getValue());
                prop.setEffectiveValue(item.getEffectiveValue());
                prop.setConfigSourcePath(item.getConfigSourcePath());
                prop.setIsDefault(item.isDefault());
                prop.setInherited(item.isInherited());
                prop.setOverridden(item.isOverridden());
                if (itemMetadata != null) {
                    metadata = new PropertyItemMetadata();
                    if (itemMetadata.getType().isArray()) {
                        metadata.setType(ClassUtils.primitiveToWrapper(itemMetadata.getType().getComponentType()).getSimpleName());
                        metadata.setMultivalue(true);
                    } else {
                        metadata.setType(ClassUtils.primitiveToWrapper((Class)itemMetadata.getType()).getSimpleName());
                    }
                    metadata.setDefaultValue(itemMetadata.getDefaultValue());
                    metadata.setLabel(itemMetadata.getLabel());
                    metadata.setDescription(itemMetadata.getDescription());
                    metadata.setProperties(this.toJsonWithValueConversion(itemMetadata.getProperties(), contextResource));
                    prop.setMetadata(metadata);
                }
            }
            props.add(prop);
        }
        result.setProperties(props);
        return result;
    }

    @Nullable
    private Map<String, Object> toJsonWithValueConversion(@Nullable Map<String, String> properties, @NotNull Resource contextResource) {
        Optional<String> dynamicProvider;
        boolean isTagBrowser;
        Optional<String> dynamicProvider2;
        boolean isPathBrowser;
        Optional<String> dynamicProvider3;
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        TreeMap<String, Object> metadataProps = new TreeMap<String, Object>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            metadataProps.put(entry.getKey(), this.tryConvertJsonString(entry.getValue()));
        }
        boolean isDropdown = "dropdown".equals(metadataProps.get("widgetType"));
        if (isDropdown && (dynamicProvider3 = Optional.ofNullable(metadataProps.get("dropdownOptionsProvider")).filter(Objects::nonNull).map(String::valueOf).filter(StringUtils::isNotBlank)).isPresent()) {
            List<Map<String, Object>> items = this.dropdownOptionProviderService.getDropdownOptions(dynamicProvider3.get(), contextResource);
            if (!items.isEmpty()) {
                metadataProps.put("dropdownOptions", items);
            }
            metadataProps.remove("dropdownOptionsProvider");
        }
        if ((isPathBrowser = "pathbrowser".equals(metadataProps.get("widgetType"))) && (dynamicProvider2 = Optional.ofNullable(metadataProps.get("pathbrowserRootPathProvider")).filter(Objects::nonNull).map(String::valueOf).filter(StringUtils::isNotBlank)).isPresent()) {
            String rootPath = this.pathBrowserRootPathProviderService.getRootPath(dynamicProvider2.get(), contextResource);
            if (rootPath != null) {
                metadataProps.put("pathbrowserRootPath", rootPath);
            }
            metadataProps.remove("pathbrowserRootPathProvider");
        }
        if ((isTagBrowser = "tagbrowser".equals(metadataProps.get("widgetType"))) && (dynamicProvider = Optional.ofNullable(metadataProps.get("tagbrowserRootPathProvider")).filter(Objects::nonNull).map(String::valueOf).filter(StringUtils::isNotBlank)).isPresent()) {
            String rootPath = this.tagBrowserRootPathProviderService.getRootPath(dynamicProvider.get(), contextResource);
            if (rootPath != null) {
                metadataProps.put("tagbrowserRootPath", rootPath);
            }
            metadataProps.remove("tagbrowserRootPathProvider");
        }
        return metadataProps;
    }

    @Nullable
    private Object tryConvertJsonString(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (JSON_STRING_ARRAY_PATTERN.matcher(value).matches()) {
            try {
                return JsonMapper.OBJECT_MAPPER.readValue(value, List.class);
            }
            catch (IOException ex) {
                log.trace("Conversion to JSON array value failed for: {}", (Object)value, (Object)ex);
            }
        }
        if (JSON_STRING_OBJECT_PATTERN.matcher(value).matches()) {
            try {
                return JsonMapper.OBJECT_MAPPER.readValue(value, Map.class);
            }
            catch (IOException ex) {
                log.trace("Conversion to JSON object value failed for: {}", (Object)value, (Object)ex);
            }
        }
        return value;
    }
}

