/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.http.CookieSameSite;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.PlatformHandler;
import io.vertx.ext.web.handler.impl.SessionHandlerImpl;
import io.vertx.ext.web.sstore.SessionStore;

@VertxGen
public interface SessionHandler
extends PlatformHandler {
    public static final String DEFAULT_SESSION_COOKIE_NAME = "vertx-web.session";
    public static final String DEFAULT_SESSION_COOKIE_PATH = "/";
    public static final long DEFAULT_SESSION_TIMEOUT = 1800000L;
    public static final boolean DEFAULT_NAG_HTTPS = true;
    public static final boolean DEFAULT_COOKIE_HTTP_ONLY_FLAG = false;
    public static final boolean DEFAULT_COOKIE_SECURE_FLAG = false;
    public static final int DEFAULT_SESSIONID_MIN_LENGTH = 16;
    public static final boolean DEFAULT_LAZY_SESSION = false;

    public static SessionHandler create(SessionStore sessionStore) {
        return new SessionHandlerImpl(sessionStore);
    }

    @Fluent
    public SessionHandler setSessionTimeout(long var1);

    @Fluent
    public SessionHandler setNagHttps(boolean var1);

    @Fluent
    public SessionHandler setCookieSecureFlag(boolean var1);

    @Fluent
    public SessionHandler setCookieHttpOnlyFlag(boolean var1);

    @Fluent
    public SessionHandler setSessionCookieName(String var1);

    @Fluent
    public SessionHandler setSessionCookiePath(String var1);

    @Fluent
    public SessionHandler setMinLength(int var1);

    @Fluent
    public SessionHandler setCookieSameSite(CookieSameSite var1);

    @Fluent
    public SessionHandler setLazySession(boolean var1);

    @Fluent
    public SessionHandler setCookieMaxAge(long var1);

    default public Future<Void> flush(RoutingContext ctx) {
        return this.flush(ctx, false);
    }

    public Future<Void> flush(RoutingContext var1, boolean var2);

    @Fluent
    public SessionHandler setCookieless(boolean var1);

    public Session newSession(RoutingContext var1);

    public Future<Void> setUser(RoutingContext var1, User var2);

    @Fluent
    public SessionHandler setSigningSecret(String var1);
}

