/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Future;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.SecurityAudit;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.internal.handler.ScopedAuthentication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JWTAuthHandlerImpl
extends HTTPAuthorizationHandler<JWTAuth>
implements JWTAuthHandler,
ScopedAuthentication<JWTAuthHandler> {
    private final List<String> scopes;
    private String delimiter;

    public JWTAuthHandlerImpl(JWTAuth authProvider, String realm) {
        super(authProvider, HTTPAuthorizationHandler.Type.BEARER, realm);
        this.scopes = Collections.emptyList();
        this.delimiter = " ";
    }

    private JWTAuthHandlerImpl(JWTAuthHandlerImpl base, List<String> scopes, String delimiter) {
        super((JWTAuth)base.authProvider, HTTPAuthorizationHandler.Type.BEARER, base.realm);
        Objects.requireNonNull(scopes, "scopes cannot be null");
        this.scopes = scopes;
        Objects.requireNonNull(delimiter, "delimiter cannot be null");
        this.delimiter = delimiter;
    }

    @Override
    public Future<User> authenticate(RoutingContext context) {
        return this.parseAuthorization(context).compose(token -> {
            int segments = 0;
            for (int i = 0; i < token.length(); ++i) {
                char c = token.charAt(i);
                if (c == '.') {
                    if (++segments != 3) continue;
                    return Future.failedFuture((Throwable)new HttpException(400, "Too many segments in token"));
                }
                if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
                return Future.failedFuture((Throwable)new HttpException(400, "Invalid character in token: " + c));
            }
            TokenCredentials credentials = new TokenCredentials(token);
            SecurityAudit audit = ((RoutingContextInternal)context).securityAudit();
            audit.credentials((Credentials)credentials);
            return ((JWTAuth)this.authProvider).authenticate((Credentials)new TokenCredentials(token)).andThen(op -> audit.audit(Marker.AUTHENTICATION, op.succeeded())).recover(err -> Future.failedFuture((Throwable)new HttpException(401, (Throwable)err)));
        });
    }

    @Override
    public JWTAuthHandler withScope(String scope) {
        Objects.requireNonNull(scope, "scope cannot be null");
        ArrayList<String> updatedScopes = new ArrayList<String>(this.scopes);
        updatedScopes.add(scope);
        return new JWTAuthHandlerImpl(this, updatedScopes, this.delimiter);
    }

    @Override
    public JWTAuthHandler withScopes(List<String> scopes) {
        Objects.requireNonNull(scopes, "scopes cannot be null");
        return new JWTAuthHandlerImpl(this, scopes, this.delimiter);
    }

    @Override
    public JWTAuthHandler scopeDelimiter(String delimiter) {
        Objects.requireNonNull(delimiter, "delimiter cannot be null");
        this.delimiter = delimiter;
        return this;
    }

    @Override
    public void postAuthentication(RoutingContext ctx) {
        User user = ctx.user().get();
        if (user == null) {
            ctx.fail(403, (Throwable)new VertxException("no user in the context", true));
            return;
        }
        List scopes = this.getScopesOrSearchMetadata(this.scopes, ctx);
        if (scopes.size() > 0) {
            JsonObject jwt = (JsonObject)user.get("accessToken");
            if (jwt == null) {
                ctx.fail(403, (Throwable)new VertxException("Invalid JWT: null", true));
                return;
            }
            if (jwt.getValue("scope") == null) {
                ctx.fail(403, (Throwable)new VertxException("Invalid JWT: scope claim is required", true));
                return;
            }
            List target = jwt.getValue("scope") instanceof String ? Stream.of(jwt.getString("scope").split(this.delimiter)).collect(Collectors.toList()) : jwt.getJsonArray("scope").getList();
            if (target != null) {
                for (String scope : scopes) {
                    if (target.contains(scope)) continue;
                    ctx.fail(403, (Throwable)new VertxException("JWT scopes != handler scopes", true));
                    return;
                }
            }
        }
        ctx.next();
    }
}

