/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.SecurityAudit;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;

public class AuthorizationHandlerImpl
implements AuthorizationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationHandler.class);
    private static final int FORBIDDEN_CODE = 403;
    private static final HttpException FORBIDDEN_EXCEPTION = new HttpException(403);
    private final Authorization authorization;
    private final Collection<AuthorizationProvider> authorizationProviders;
    private BiConsumer<RoutingContext, AuthorizationContext> variableHandler;

    public AuthorizationHandlerImpl(Authorization authorization) {
        this.authorization = Objects.requireNonNull(authorization);
        this.authorizationProviders = new ArrayList<AuthorizationProvider>();
    }

    public AuthorizationHandlerImpl() {
        this.authorization = null;
        this.authorizationProviders = new ArrayList<AuthorizationProvider>();
    }

    private Authorization computeAuthorizationIfNeeded(RoutingContext ctx) {
        if (this.authorization != null) {
            return this.authorization;
        }
        String domain = null;
        String operation = null;
        String resource = null;
        Route route = ctx.currentRoute();
        if (route != null) {
            domain = (String)route.getMetadata("X-ABAC-Domain");
            operation = (String)route.getMetadata("X-ABAC-Operation");
            resource = (String)route.getMetadata("X-ABAC-Resource");
        }
        if (domain == null) {
            domain = "web";
        }
        if (operation != null && resource != null) {
            return PermissionBasedAuthorization.create((String)(domain + ":" + operation)).setResource(resource);
        }
        return PermissionBasedAuthorization.create((String)(domain + ":" + ctx.request().method().name())).setResource(ctx.normalizedPath());
    }

    public void handle(RoutingContext ctx) {
        User user = ctx.user().get();
        if (user == null) {
            ctx.fail(403, FORBIDDEN_EXCEPTION);
        } else {
            try {
                AuthorizationContext authorizationContext;
                if (!ctx.request().isEnded()) {
                    ctx.request().pause();
                }
                if (this.variableHandler == null) {
                    authorizationContext = AuthorizationContext.create((User)user, (MultiMap)ctx.request().params());
                } else {
                    authorizationContext = AuthorizationContext.create((User)user);
                    this.variableHandler.accept(ctx, authorizationContext);
                }
                this.checkOrFetchAuthorizations(ctx, this.computeAuthorizationIfNeeded(ctx), authorizationContext, this.authorizationProviders.iterator());
            }
            catch (RuntimeException e) {
                if (!ctx.request().isEnded()) {
                    ctx.request().resume();
                }
                ctx.fail(e);
            }
        }
    }

    @Override
    public AuthorizationHandler variableConsumer(BiConsumer<RoutingContext, AuthorizationContext> handler) {
        this.variableHandler = handler;
        return this;
    }

    private void checkOrFetchAuthorizations(RoutingContext ctx, Authorization authorization, AuthorizationContext authorizationContext, Iterator<AuthorizationProvider> providers) {
        User user = ctx.user().get();
        SecurityAudit audit = ((RoutingContextInternal)ctx).securityAudit();
        audit.authorization(authorization);
        audit.user(user);
        if (authorization.match(authorizationContext)) {
            audit.audit(Marker.AUTHORIZATION, true);
            if (!ctx.request().isEnded()) {
                ctx.request().resume();
            }
            ctx.next();
            return;
        }
        if (user == null || !providers.hasNext()) {
            if (!ctx.request().isEnded()) {
                ctx.request().resume();
            }
            audit.audit(Marker.AUTHORIZATION, false);
            ctx.fail(403, FORBIDDEN_EXCEPTION);
            return;
        }
        do {
            AuthorizationProvider provider = providers.next();
            if (user.authorizations().contains(provider.getId())) continue;
            provider.getAuthorizations(user).onFailure(err -> LOG.warn((Object)("An error occurred getting authorization - providerId: " + provider.getId()), err)).eventually(() -> {
                this.checkOrFetchAuthorizations(ctx, authorization, authorizationContext, providers);
                return Future.succeededFuture();
            });
            return;
        } while (providers.hasNext());
        if (!ctx.request().isEnded()) {
            ctx.request().resume();
        }
        audit.audit(Marker.AUTHORIZATION, false);
        ctx.fail(403, FORBIDDEN_EXCEPTION);
    }

    @Override
    public AuthorizationHandler addAuthorizationProvider(AuthorizationProvider authorizationProvider) {
        Objects.requireNonNull(authorizationProvider);
        this.authorizationProviders.add(authorizationProvider);
        return this;
    }
}

