/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.net.SocketAddress;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class ServerWebSocketWrapper
implements ServerWebSocket {
    private final ServerWebSocket delegate;
    private final String host;
    private final String scheme;
    private final boolean isSsl;
    private final SocketAddress remoteAddress;

    public ServerWebSocketWrapper(ServerWebSocket delegate, String host, String scheme, boolean isSsl, SocketAddress remoteAddress) {
        this.delegate = delegate;
        this.host = host;
        this.scheme = scheme;
        this.isSsl = isSsl;
        this.remoteAddress = remoteAddress;
    }

    public ServerWebSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Future<Void> write(Buffer data) {
        return this.delegate.write((Object)data);
    }

    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write((Object)data, handler);
    }

    public ServerWebSocket handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        return this;
    }

    public ServerWebSocket pause() {
        this.delegate.pause();
        return this;
    }

    public ServerWebSocket resume() {
        this.delegate.resume();
        return this;
    }

    public ServerWebSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public ServerWebSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public ServerWebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public boolean writeQueueFull() {
        return this.delegate.writeQueueFull();
    }

    public ServerWebSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public String binaryHandlerID() {
        return this.delegate.binaryHandlerID();
    }

    public String textHandlerID() {
        return this.delegate.textHandlerID();
    }

    public String subProtocol() {
        return this.delegate.subProtocol();
    }

    public Short closeStatusCode() {
        return this.delegate.closeStatusCode();
    }

    public String closeReason() {
        return this.delegate.closeReason();
    }

    public MultiMap headers() {
        return this.delegate.headers();
    }

    public Future<Void> writeFrame(WebSocketFrame frame) {
        return this.delegate.writeFrame(frame);
    }

    public ServerWebSocket writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFrame(frame, handler);
        return this;
    }

    public Future<Void> writeFinalTextFrame(String text) {
        return this.delegate.writeFinalTextFrame(text);
    }

    public ServerWebSocket writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalTextFrame(text, handler);
        return this;
    }

    public Future<Void> writeFinalBinaryFrame(Buffer data) {
        return this.delegate.writeFinalBinaryFrame(data);
    }

    public ServerWebSocket writeFinalBinaryFrame(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalBinaryFrame(data, handler);
        return this;
    }

    public Future<Void> writeBinaryMessage(Buffer data) {
        return this.delegate.writeBinaryMessage(data);
    }

    public ServerWebSocket writeBinaryMessage(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeBinaryMessage(data, handler);
        return this;
    }

    public Future<Void> writeTextMessage(String text) {
        return this.delegate.writeTextMessage(text);
    }

    public ServerWebSocket writeTextMessage(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeTextMessage(text, handler);
        return this;
    }

    public WebSocketBase writePing(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writePing(data, handler);
        return this;
    }

    public Future<Void> writePing(Buffer data) {
        return this.delegate.writePing(data);
    }

    public WebSocketBase writePong(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writePong(data, handler);
        return this;
    }

    public Future<Void> writePong(Buffer data) {
        return this.delegate.writePong(data);
    }

    public ServerWebSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public ServerWebSocket frameHandler(Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler(handler);
        return this;
    }

    public WebSocketBase textMessageHandler(@Nullable Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    public WebSocketBase binaryMessageHandler(@Nullable Handler<Buffer> handler) {
        this.delegate.binaryMessageHandler(handler);
        return this;
    }

    public WebSocketBase pongHandler(@Nullable Handler<Buffer> handler) {
        this.delegate.pongHandler(handler);
        return this;
    }

    public Future<Void> end() {
        return this.delegate.end();
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    public @Nullable String scheme() {
        return this.scheme;
    }

    public @Nullable String host() {
        return this.host;
    }

    public String uri() {
        return this.delegate.uri();
    }

    public String path() {
        return this.delegate.path();
    }

    public @Nullable String query() {
        return this.delegate.query();
    }

    public void accept() {
        this.delegate.accept();
    }

    public void reject() {
        this.delegate.reject();
    }

    public void reject(int status) {
        this.delegate.reject(status);
    }

    public void setHandshake(Future<Integer> future, Handler<AsyncResult<Integer>> handler) {
        this.delegate.setHandshake(future, handler);
    }

    public Future<Integer> setHandshake(Future<Integer> future) {
        return this.delegate.setHandshake(future);
    }

    public Future<Void> close() {
        return this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Future<Void> close(short statusCode) {
        return this.delegate.close(statusCode);
    }

    public void close(short statusCode, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, handler);
    }

    public Future<Void> close(short statusCode, @Nullable String reason) {
        return this.delegate.close(statusCode, reason);
    }

    public void close(short statusCode, @Nullable String reason, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, reason, handler);
    }

    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    public boolean isSsl() {
        return this.isSsl;
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public SSLSession sslSession() {
        return this.delegate.sslSession();
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.delegate.peerCertificateChain();
    }
}

