/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.FormLoginHandler;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.impl.RoutingContextInternal;

public class FormLoginHandlerImpl
extends AuthenticationHandlerImpl<AuthenticationProvider>
implements FormLoginHandler {
    private String usernameParam;
    private String passwordParam;
    private String returnURLParam;
    private String directLoggedInOKURL;
    private static final String DEFAULT_DIRECT_LOGGED_IN_OK_PAGE = "<html><body><h1>Login successful</h1></body></html>";

    @Override
    public FormLoginHandler setUsernameParam(String usernameParam) {
        this.usernameParam = usernameParam;
        return this;
    }

    @Override
    public FormLoginHandler setPasswordParam(String passwordParam) {
        this.passwordParam = passwordParam;
        return this;
    }

    @Override
    public FormLoginHandler setReturnURLParam(String returnURLParam) {
        this.returnURLParam = returnURLParam;
        return this;
    }

    @Override
    public FormLoginHandler setDirectLoggedInOKURL(String directLoggedInOKURL) {
        this.directLoggedInOKURL = directLoggedInOKURL;
        return this;
    }

    public FormLoginHandlerImpl(AuthenticationProvider authProvider, String usernameParam, String passwordParam, String returnURLParam, String directLoggedInOKURL) {
        super(authProvider);
        this.usernameParam = usernameParam;
        this.passwordParam = passwordParam;
        this.returnURLParam = returnURLParam;
        this.directLoggedInOKURL = directLoggedInOKURL;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<Credentials>> handler) {
        HttpServerRequest req = context.request();
        if (req.method() != HttpMethod.POST) {
            handler.handle((Object)Future.failedFuture((Throwable)BAD_METHOD));
        } else if (!((RoutingContextInternal)context).seenHandler(2)) {
            handler.handle((Object)Future.failedFuture((Throwable)new NoStackTraceThrowable("BodyHandler is required to process POST requests")));
        } else {
            MultiMap params = req.formAttributes();
            String username = params.get(this.usernameParam);
            String password = params.get(this.passwordParam);
            if (username == null || password == null) {
                handler.handle((Object)Future.failedFuture((Throwable)BAD_REQUEST));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)new UsernamePasswordCredentials(username, password)));
            }
        }
    }

    @Override
    public void postAuthentication(RoutingContext ctx) {
        String returnURL;
        HttpServerRequest req = ctx.request();
        Session session = ctx.session();
        if (session != null && (returnURL = (String)session.remove(this.returnURLParam)) != null) {
            this.doRedirect(req.response(), returnURL);
            return;
        }
        if (this.directLoggedInOKURL != null) {
            this.doRedirect(req.response(), this.directLoggedInOKURL);
        } else {
            req.response().end(DEFAULT_DIRECT_LOGGED_IN_OK_PAGE);
        }
    }

    private void doRedirect(HttpServerResponse response, String url) {
        response.putHeader(HttpHeaders.LOCATION, (CharSequence)url).setStatusCode(302).end();
    }
}

