/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;

public class Utils
extends io.vertx.core.impl.Utils {
    private static final ZoneId ZONE_GMT = ZoneId.of("GMT");
    private static final Pattern CACHE_CONTROL_NO_CACHE_REGEXP = Pattern.compile("(?:^|,)\\s*?no-cache\\s*?(?:,|$)");

    public static ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl == null ? Utils.class.getClassLoader() : tccl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Buffer readResourceToBuffer(String resource) {
        ClassLoader cl = Utils.getClassLoader();
        try {
            Buffer buffer = Buffer.buffer();
            try (InputStream in = cl.getResourceAsStream(resource);){
                int read;
                if (in == null) {
                    Buffer buffer2 = null;
                    return buffer2;
                }
                byte[] data = new byte[4096];
                while ((read = in.read(data, 0, data.length)) != -1) {
                    if (read == data.length) {
                        buffer.appendBytes(data);
                        continue;
                    }
                    byte[] slice = new byte[read];
                    System.arraycopy(data, 0, slice, 0, slice.length);
                    buffer.appendBytes(slice);
                }
                return buffer;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String readFileToString(Vertx vertx, String resource) {
        return Utils.readFileToString(vertx, resource, StandardCharsets.UTF_8);
    }

    private static String readFileToString(Vertx vertx, String resource, Charset charset) {
        try {
            Buffer buff = vertx.fileSystem().readFileBlocking(resource);
            return buff.toString(charset);
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    public static String formatRFC1123DateTime(long time) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(Instant.ofEpochMilli(time).atZone(ZONE_GMT));
    }

    public static long parseRFC1123DateTime(String header) {
        try {
            return header == null || header.isEmpty() ? -1L : LocalDateTime.parse(header, DateTimeFormatter.RFC_1123_DATE_TIME).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        catch (DateTimeParseException ex) {
            return -1L;
        }
    }

    public static String pathOffset(String path, RoutingContext context) {
        String routePath;
        int prefixLen = 0;
        String mountPoint = context.mountPoint();
        if (mountPoint != null) {
            prefixLen = mountPoint.length();
            if (mountPoint.charAt(mountPoint.length() - 1) == '/') {
                --prefixLen;
            }
        }
        if ((routePath = context.currentRoute().getPath()) != null) {
            prefixLen += routePath.length();
            if (routePath.charAt(routePath.length() - 1) == '/') {
                --prefixLen;
            }
        }
        return prefixLen != 0 ? path.substring(prefixLen) : path;
    }

    public static long secondsFactor(long millis) {
        return millis - millis % 1000L;
    }

    public static boolean isJsonContentType(String contentType) {
        return contentType.contains("application/json") || contentType.contains("+json");
    }

    public static boolean isXMLContentType(String contentType) {
        return contentType.contains("application/xml") || contentType.contains("text/xml") || contentType.contains("+xml");
    }

    public static void addToMapIfAbsent(MultiMap map, CharSequence key, String value) {
        if (!map.contains(key)) {
            map.set(key, (CharSequence)value);
        }
    }

    public static boolean fresh(RoutingContext ctx) {
        return Utils.fresh(ctx, -1L);
    }

    public static boolean fresh(RoutingContext ctx, long lastModified) {
        HttpServerRequest req = ctx.request();
        HttpServerResponse res = ctx.response();
        String modifiedSince = req.getHeader(HttpHeaders.IF_MODIFIED_SINCE);
        String noneMatch = req.getHeader(HttpHeaders.IF_NONE_MATCH);
        if (modifiedSince == null && noneMatch == null) {
            return false;
        }
        String cacheControl = req.getHeader(HttpHeaders.CACHE_CONTROL);
        if (cacheControl != null && CACHE_CONTROL_NO_CACHE_REGEXP.matcher(cacheControl).find()) {
            return false;
        }
        if (noneMatch != null && !"*".equals(noneMatch)) {
            String etag = res.headers().get(HttpHeaders.ETAG);
            if (etag == null) {
                return false;
            }
            boolean etagStale = true;
            int end = 0;
            int start = 0;
            block4: for (int i = 0; i < noneMatch.length(); ++i) {
                switch (noneMatch.charAt(i)) {
                    case ' ': {
                        if (start != end) continue block4;
                        start = end = i + 1;
                        continue block4;
                    }
                    case ',': {
                        String match = noneMatch.substring(start, end);
                        if (match.equals(etag) || match.equals("W/" + etag) || ("W/" + match).equals(etag)) {
                            etagStale = false;
                            break block4;
                        }
                        start = end = i + 1;
                        continue block4;
                    }
                    default: {
                        end = i + 1;
                    }
                }
            }
            if (etagStale) {
                return false;
            }
        }
        if (modifiedSince != null) {
            if (lastModified == -1L) {
                lastModified = Utils.parseRFC1123DateTime(res.headers().get(HttpHeaders.LAST_MODIFIED));
            }
            boolean modifiedStale = lastModified == -1L || lastModified > Utils.parseRFC1123DateTime(modifiedSince);
            return !modifiedStale;
        }
        return true;
    }
}

