/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import java.util.List;

public class JWTAuthHandlerImpl
extends HTTPAuthorizationHandler
implements JWTAuthHandler {
    private final JsonObject options = new JsonObject();

    public JWTAuthHandlerImpl(JWTAuth authProvider) {
        super((AuthenticationProvider)authProvider, HTTPAuthorizationHandler.Type.BEARER);
    }

    @Override
    public JWTAuthHandler setAudience(List<String> audience) {
        this.options.put("audience", (Object)new JsonArray(audience));
        return this;
    }

    @Override
    public JWTAuthHandler setIssuer(String issuer) {
        this.options.put("issuer", (Object)issuer);
        return this;
    }

    @Override
    public JWTAuthHandler setIgnoreExpiration(boolean ignoreExpiration) {
        this.options.put("ignoreExpiration", (Object)ignoreExpiration);
        return this;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        this.parseAuthorization(context, false, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            handler.handle((Object)Future.succeededFuture((Object)new JsonObject().put("jwt", parseAuthorization.result()).put("options", (Object)this.options)));
        }));
    }

    @Override
    public String authenticateHeader(RoutingContext context) {
        if (this.realm != null && this.realm.length() > 0) {
            return "Bearer realm=\"" + this.realm + "\"";
        }
        return null;
    }
}

