/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;

abstract class HTTPAuthorizationHandler
extends AuthenticationHandlerImpl {
    protected final Type type;

    HTTPAuthorizationHandler(AuthenticationProvider authProvider, Type type) {
        super(authProvider);
        this.type = type;
    }

    HTTPAuthorizationHandler(AuthenticationProvider authProvider, String realm, Type type) {
        super(authProvider, realm);
        this.type = type;
    }

    protected final void parseAuthorization(RoutingContext ctx, boolean optional, Handler<AsyncResult<String>> handler) {
        HttpServerRequest request = ctx.request();
        String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
        if (authorization == null) {
            if (optional) {
                handler.handle((Object)Future.succeededFuture());
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)UNAUTHORIZED));
            }
            return;
        }
        try {
            int idx = authorization.indexOf(32);
            if (idx <= 0) {
                handler.handle((Object)Future.failedFuture((Throwable)BAD_REQUEST));
                return;
            }
            if (!this.type.is(authorization.substring(0, idx))) {
                handler.handle((Object)Future.failedFuture((Throwable)UNAUTHORIZED));
                return;
            }
            handler.handle((Object)Future.succeededFuture((Object)authorization.substring(idx + 1)));
        }
        catch (RuntimeException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    static enum Type {
        BASIC("Basic"),
        DIGEST("Digest"),
        BEARER("Bearer"),
        HOBA("HOBA"),
        MUTUAL("Mutual"),
        NEGOTIATE("Negotiate"),
        OAUTH("OAuth"),
        SCRAM_SHA_1("SCRAM-SHA-1"),
        SCRAM_SHA_256("SCRAM-SHA-256");

        private final String label;

        private Type(String label) {
            this.label = label;
        }

        public boolean is(String other) {
            return this.label.equalsIgnoreCase(other);
        }
    }
}

