/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.impl.ForwardedParser;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

class HttpServerRequestWrapper
implements HttpServerRequest {
    private final HttpServerRequest delegate;
    private final ForwardedParser forwardedParser;
    private boolean modified;
    private HttpMethod method;
    private String rawMethod;
    private String path;
    private String query;
    private String uri;
    private String absoluteURI;

    HttpServerRequestWrapper(HttpServerRequest request, boolean allowForward) {
        this.delegate = request;
        this.forwardedParser = new ForwardedParser(this.delegate, allowForward);
    }

    void changeTo(HttpMethod method, String uri) {
        this.modified = true;
        this.method = method;
        this.uri = uri;
        this.rawMethod = null;
        this.path = null;
        this.query = null;
        this.absoluteURI = null;
        int queryIndex = uri.indexOf(63);
        int fragmentIndex = uri.indexOf(35);
        if (queryIndex != -1) {
            this.path = uri.substring(0, queryIndex);
            this.query = fragmentIndex != -1 ? uri.substring(queryIndex + 1, fragmentIndex) : uri.substring(queryIndex + 1);
        } else {
            this.path = fragmentIndex != -1 ? uri.substring(0, fragmentIndex) : uri;
        }
    }

    public Future<Buffer> body() {
        return this.delegate.body();
    }

    public long bytesRead() {
        return this.delegate.bytesRead();
    }

    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        return this.delegate.exceptionHandler(handler);
    }

    public HttpServerRequest handler(Handler<Buffer> handler) {
        return this.delegate.handler(handler);
    }

    public HttpServerRequest pause() {
        return this.delegate.pause();
    }

    public HttpServerRequest resume() {
        return this.delegate.resume();
    }

    public HttpServerRequest fetch(long amount) {
        return this.delegate.fetch(amount);
    }

    public HttpServerRequest endHandler(Handler<Void> handler) {
        return this.delegate.endHandler(handler);
    }

    public HttpVersion version() {
        return this.delegate.version();
    }

    public HttpMethod method() {
        if (!this.modified) {
            return this.delegate.method();
        }
        return this.method;
    }

    public String rawMethod() {
        if (!this.modified) {
            return this.delegate.rawMethod();
        }
        if (this.rawMethod == null) {
            this.rawMethod = this.method.toString();
        }
        return this.rawMethod;
    }

    public String uri() {
        if (!this.modified) {
            return this.delegate.uri();
        }
        return this.uri;
    }

    public String path() {
        if (!this.modified) {
            return this.delegate.path();
        }
        return this.path;
    }

    public String query() {
        if (!this.modified) {
            return this.delegate.query();
        }
        return this.query;
    }

    public HttpServerResponse response() {
        return this.delegate.response();
    }

    public MultiMap headers() {
        return this.delegate.headers();
    }

    public String getHeader(String s) {
        return this.delegate.getHeader(s);
    }

    public String getHeader(CharSequence charSequence) {
        return this.delegate.getHeader(charSequence);
    }

    public MultiMap params() {
        return this.delegate.params();
    }

    public String getParam(String s) {
        return this.delegate.getParam(s);
    }

    public SocketAddress remoteAddress() {
        return this.forwardedParser.remoteAddress();
    }

    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.delegate.peerCertificateChain();
    }

    public SSLSession sslSession() {
        return this.delegate.sslSession();
    }

    public String absoluteURI() {
        if (!this.modified) {
            return this.forwardedParser.absoluteURI();
        }
        if (this.absoluteURI == null) {
            String scheme = this.forwardedParser.scheme();
            String host = this.forwardedParser.host();
            this.absoluteURI = scheme != null && host != null ? scheme + "://" + host + this.uri : this.uri;
        }
        return this.absoluteURI;
    }

    public String scheme() {
        return this.forwardedParser.scheme();
    }

    public String host() {
        return this.forwardedParser.host();
    }

    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler(handler);
        return this;
    }

    public HttpConnection connection() {
        return this.delegate.connection();
    }

    public HttpServerRequest bodyHandler(Handler<Buffer> handler) {
        return this.delegate.bodyHandler(handler);
    }

    public NetSocket netSocket() {
        return this.delegate.netSocket();
    }

    public HttpServerRequest setExpectMultipart(boolean b) {
        return this.delegate.setExpectMultipart(b);
    }

    public boolean isExpectMultipart() {
        return this.delegate.isExpectMultipart();
    }

    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        return this.delegate.uploadHandler(handler);
    }

    public MultiMap formAttributes() {
        return this.delegate.formAttributes();
    }

    public String getFormAttribute(String s) {
        return this.delegate.getFormAttribute(s);
    }

    public ServerWebSocket upgrade() {
        return this.delegate.upgrade();
    }

    public boolean isEnded() {
        return this.delegate.isEnded();
    }

    public boolean isSSL() {
        return this.forwardedParser.isSSL();
    }

    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    public StreamPriority streamPriority() {
        return this.delegate.streamPriority();
    }

    public @Nullable Cookie getCookie(String name) {
        return this.delegate.getCookie(name);
    }

    public int cookieCount() {
        return this.delegate.cookieCount();
    }

    public Map<String, Cookie> cookieMap() {
        return this.delegate.cookieMap();
    }
}

